/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "NoteStructure.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::NoteStructure::setNoteXref (std::string const &value)
{
  _note_xref = value;
  return;
}

void
GEDCOMParser::NoteStructure::concSubmitterText (std::string const &value)
{
  _submitter_text = _submitter_text + value;
  return;
}

void
GEDCOMParser::NoteStructure::contSubmitterText (std::string const &value)
{
  _submitter_text = _submitter_text + "\n" + value;
  return;
}


GEDCOMParser::NoteStructure::~NoteStructure (void)
{
}

std::string const &
GEDCOMParser::NoteStructure::getNoteXref (void) const
{
  return _note_xref;
}

std::string const &
GEDCOMParser::NoteStructure::getSubmitterText (void) const
{
  return _submitter_text;
}

void
GEDCOMParser::NoteStructure::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitNoteStructure (this);
  return;
}
