/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "MultimediaRecord.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

std::string const
  NEWLINE =
  "\n";

GEDCOMParser::MultimediaRecord::MultimediaRecord (std::string const &id = "")
{
  if (id != "")
    {
      setId (id);
    }
  return;
}

void
GEDCOMParser::MultimediaRecord::setId (std::string const &data)
{
  _obje_id = data;
  return;
}

void
GEDCOMParser::MultimediaRecord::setForm (std::string const &data)
{
  _form = data;
  return;
}

void
GEDCOMParser::MultimediaRecord::setTitl (std::string const &data)
{
  _titl = data;
  return;
}

void
GEDCOMParser::MultimediaRecord::contBlob (std::string const &data)
{
  _blob = _blob + NEWLINE + data;
  return;
}

void
GEDCOMParser::MultimediaRecord::setObjeXref (std::string const &data)
{
  _obje_xref = data;
  return;
}

std::string const &
GEDCOMParser::MultimediaRecord::getId (void) const
{
  return _obje_id;
}

std::string const &
GEDCOMParser::MultimediaRecord::getForm (void) const
{
  return _form;
}

std::string const &
GEDCOMParser::MultimediaRecord::getTitl (void) const
{
  return _titl;
}

std::string const &
GEDCOMParser::MultimediaRecord::getBlob (void) const
{
  return _blob;
}

std::string const &
GEDCOMParser::MultimediaRecord::getObjeXref (void) const
{
  return _obje_xref;
}

void
GEDCOMParser::MultimediaRecord::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitMultimediaRecord (this);
  return;
}
