/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "MultimediaLink.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::MultimediaLink::setObjXref (std::string const &value)
{
  _obj_xref = value;
  return;
}

void
GEDCOMParser::MultimediaLink::setFormat (std::string const &value)
{
  _format = value;
  return;
}

void
GEDCOMParser::MultimediaLink::setTitle (std::string const &value)
{
  _title = value;
  return;
}

void
GEDCOMParser::MultimediaLink::setMMFileRef (std::string const &value)
{
  _mm_file_reference = value;
  return;
}

GEDCOMParser::MultimediaLink::~MultimediaLink (void)
{
}

std::string const &
GEDCOMParser::MultimediaLink::getObjXref (void) const
{
  return _obj_xref;
}

std::string const &
GEDCOMParser::MultimediaLink::getFormat (void) const
{
  return _format;
}

std::string const &
GEDCOMParser::MultimediaLink::getTitle (void) const
{
  return _title;
}

std::string const &
GEDCOMParser::MultimediaLink::getMMFileRef (void) const
{
  return _mm_file_reference;
}

void
GEDCOMParser::MultimediaLink::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitMultimediaLink (this);
  return;
}
