/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "LineageLinkageGedcom.hh"
#include <algorithm>
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"
#include <iostream>

GEDCOMParser::Header *
  GEDCOMParser::LineageLinkageGedcom::setHeader (GEDCOMParser::Header *
						 const data = 0)
{
  GEDCOMParser::Header * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      if (factory != 0)
	{
	  tmp_data = factory->createHeader ();
	}
    }
  _header = SmartPtr < Header > (tmp_data);
  return _header.getPtr ();
}

GEDCOMParser::Submission *
  GEDCOMParser::LineageLinkageGedcom::setSubmission (GEDCOMParser::
						     Submission * const data =
						     0)
{
  GEDCOMParser::Submission * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSubmission ();
    }
  _submission = SmartPtr < Submission > (tmp_data);
  return _submission.getPtr ();
}

GEDCOMParser::FamilyRecord *
  GEDCOMParser::LineageLinkageGedcom::addFamilyRecord (FamilyRecord *
						       const data = 0)
{
  std::string id;
  FamilyRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createFamilyRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _family_records[id] = SmartPtr < FamilyRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _family_records[id].getPtr ();
}

GEDCOMParser::IndividualRecord *
  GEDCOMParser::LineageLinkageGedcom::addIndividualRecord (IndividualRecord *
							   const data = 0)
{
  std::string id;
  IndividualRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createIndividualRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _individual_records[id] = SmartPtr < IndividualRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _individual_records[id].getPtr ();
}

GEDCOMParser::MultimediaRecord *
  GEDCOMParser::LineageLinkageGedcom::addMultimediaRecord (MultimediaRecord *
							   const data = 0)
{
  std::string id;
  MultimediaRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createMultimediaRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _multimedia_records[id] = SmartPtr < MultimediaRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _multimedia_records[id].getPtr ();
}

GEDCOMParser::NoteRecord *
  GEDCOMParser::LineageLinkageGedcom::addNoteRecord (NoteRecord * const data =
						     0)
{
  std::string id;
  NoteRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createNoteRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _note_records[id] = SmartPtr < NoteRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _note_records[id].getPtr ();

}

GEDCOMParser::RepositoryRecord *
  GEDCOMParser::LineageLinkageGedcom::addRepositoryRecord (RepositoryRecord *
							   const data = 0)
{
  std::string id;
  RepositoryRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createRepositoryRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _repository_records[id] = SmartPtr < RepositoryRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _repository_records[id].getPtr ();
}

GEDCOMParser::SourceRecord *
  GEDCOMParser::LineageLinkageGedcom::addSourceRecord (SourceRecord *
						       const data = 0)
{
  std::string id;
  SourceRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSourceRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _source_records[id] = SmartPtr < SourceRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _source_records[id].getPtr ();
}

GEDCOMParser::SubmitterRecord *
  GEDCOMParser::LineageLinkageGedcom::addSubmitterRecord (SubmitterRecord *
							  const data = 0)
{
  std::string id;
  SubmitterRecord *
    tmp_data;
  if (_id_generator == 0)
    {
      _id_generator = new GEDCOMParser::IdGenerator ();
    }

  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSubmitterRecord (_id_generator->getId ());
    }
  else
    {
      tmp_data = data;
    }
  id = tmp_data->getId ();
  _submitter_records[id] = SmartPtr < SubmitterRecord > (tmp_data);
  _id_generator->addUsedId (id);
  return _submitter_records[id].getPtr ();
}

void
GEDCOMParser::LineageLinkageGedcom::RemoveFamilyRecord (SmartPtr <
							GEDCOMParser::
							FamilyRecord >
							const &family)
{
  GEDCOMParser::FamilyRecords_t::iterator family_iter =
    _family_records.find (family->getId ());
  _family_records.erase (family_iter);
  return;
}

SmartPtr < GEDCOMParser::Header > const &
GEDCOMParser::LineageLinkageGedcom::getHeader (void) const
{
  return _header;
}

SmartPtr < GEDCOMParser::Submission > const &
GEDCOMParser::LineageLinkageGedcom::getSubmission (void) const
{
  return _submission;
}

GEDCOMParser::FamilyRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getFamilyRecords (void) const
{
  return _family_records;
}

GEDCOMParser::IndividualRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getIndividualRecords (void) const
{
  return _individual_records;
}

GEDCOMParser::MultimediaRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getMultimediaRecords (void) const
{
  return _multimedia_records;
}

GEDCOMParser::NoteRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getNoteRecords (void) const
{
  return _note_records;
}

GEDCOMParser::RepositoryRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getRepositoryRecords (void) const
{
  return _repository_records;
}

GEDCOMParser::SourceRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getSourceRecords (void) const
{
  return _source_records;
}

GEDCOMParser::SubmitterRecords_t const &
GEDCOMParser::LineageLinkageGedcom::getSubmitterRecords (void) const
{
  return _submitter_records;
}

GEDCOMParser::LineageLinkageGedcom::~LineageLinkageGedcom (void)
{
  delete
    _id_generator;
  _id_generator = 0;
}

void
GEDCOMParser::LineageLinkageGedcom::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitLineageLinkageGedcom (this);
  return;
}

void
GEDCOMParser::LineageLinkageGedcom::clear (void)
{
  _header.setNull ();
  _submission.setNull ();
  for (FamilyRecords_t::iterator iter = _family_records.begin ();
       iter != _family_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _family_records.clear ();
  for (IndividualRecords_t::iterator iter = _individual_records.begin ();
       iter != _individual_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _individual_records.clear ();
  for (MultimediaRecords_t::iterator iter = _multimedia_records.begin ();
       iter != _multimedia_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _multimedia_records.clear ();
  for (NoteRecords_t::iterator iter = _note_records.begin ();
       iter != _note_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _note_records.clear ();
  for (RepositoryRecords_t::iterator iter = _repository_records.begin ();
       iter != _repository_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _repository_records.clear ();
  for (SourceRecords_t::iterator iter = _source_records.begin ();
       iter != _source_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _source_records.clear ();
  for (SubmitterRecords_t::iterator iter = _submitter_records.begin ();
       iter != _submitter_records.end (); iter++)
    {
      iter->second.setNull ();
    }
  _submitter_records.clear ();
  delete
    _id_generator;
  _id_generator = 0;
  return;
}
