/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_LDS_SPOUSE_SEALING_HH_
#define _GEDCOMPARSER_LDS_SPOUSE_SEALING_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"
////
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  class LdsSpouseSealing;
  ///@name typedefs
  //@{
  /// @doc handling of many lds spouse sealings
  typedef std::vector < SmartPtr < LdsSpouseSealing > >LdsSpouseSealings_t;
  //@}
}

#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/DateManagement/DateValue.hh"

///
namespace GEDCOMParser
{
  /// @memo Implements the GEDCOM 5.5 LDS_SPOUSE_SEALING structure   
  class LdsSpouseSealing:public GEDCOMElement, public AttachmentManager
  {
  protected:
    ///
    std::string _status;
    ///
    GEDCOMParser::DateManagement::DateValue * _date;
    ///
    std::string _temp;
    ///
    std::string _plac;
  public:
    ///
    LdsSpouseSealing (void):_status (), _date (0), _temp (), _plac ()
    {
      return;
    }
    ///
    LdsSpouseSealing (LdsSpouseSealing const &l):_status (l._status),
      _date (0), _temp (l._temp), _plac (l._plac)
    {
      if (l._date != 0)
	{
	  _date = new GEDCOMParser::DateManagement::DateValue (*l._date);
	}
      return;
    }
    ///
    virtual ~ LdsSpouseSealing (void)
    {
      delete _date;
      _date = 0;
      return;
    };
    ///@name Accessors (set) 
    //@{  
    void setStatus (std::string const &);
    ///
    void setDate (std::string const &);
    ///
    void setTempleCode (std::string const &);
    ///
    void setPlace (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{   
    ///
    virtual std::string const &getStatus (void) const;
    ///
    virtual std::string const getDate (void) const;
    ///
    GEDCOMParser::DateManagement::
      DateValue const *const getDateObject (void) const;
    ///
    virtual std::string const &getTempleCode (void) const;
    ///
    virtual std::string const &getPlace (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
