/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "LdsSpouseSealing.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::LdsSpouseSealing::setStatus (std::string const &value)
{
  _status = value;
  return;
}

void
GEDCOMParser::LdsSpouseSealing::setDate (std::string const &value)
{
  if (_date != 0)
    {
      delete
	_date;
      _date = 0;
    }
  _date = new GEDCOMParser::DateManagement::DateValue (value);
  return;
}

void
GEDCOMParser::LdsSpouseSealing::setTempleCode (std::string const &value)
{
  _temp = value;
  return;
}

void
GEDCOMParser::LdsSpouseSealing::setPlace (std::string const &value)
{
  _plac = value;
  return;
}

std::string const &
GEDCOMParser::LdsSpouseSealing::getStatus (void) const
{
  return _status;
}

std::string const
GEDCOMParser::LdsSpouseSealing::getDate (void) const
{
  std::string res;
  if (_date != 0)
    {
      res = _date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const *const
GEDCOMParser::LdsSpouseSealing::getDateObject (void) const
{
  return _date;
}

std::string const &
GEDCOMParser::LdsSpouseSealing::getTempleCode (void) const
{
  return _temp;
}

std::string const &
GEDCOMParser::LdsSpouseSealing::getPlace (void) const
{
  return _plac;
}

void
GEDCOMParser::LdsSpouseSealing::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitLdsSpouseSealing (this);
  return;
}
