/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "IndividualRecord.hh"
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

#include <iostream>

std::string const
  GEDCOMParser::IndividualRecord::MALE =
  "M";
std::string const
  GEDCOMParser::IndividualRecord::FEMALE =
  "F";

GEDCOMParser::IndividualRecord::IndividualRecord (std::string const &id = "")
{
  if (id != "")
    {
      setId (id);
    }
  return;
}

void
GEDCOMParser::IndividualRecord::setId (std::string const &value)
{
  _id = value;
  return;
}

void
GEDCOMParser::IndividualRecord::setResn (std::string const &value)
{
  _resn = value;
  return;
}

GEDCOMParser::PersonalName *
  GEDCOMParser::IndividualRecord::addPersonalName (PersonalName * const data =
						   0)
{
  GEDCOMParser::PersonalName * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createPersonalName ();
    }
  _personal_names.push_back (SmartPtr < PersonalName > (tmp_data));
  return _personal_names.back ().getPtr ();
}

void
GEDCOMParser::IndividualRecord::setSex (std::string const &value)
{
  _sex = value;
  return;
}

GEDCOMParser::IndividualEvent *
  GEDCOMParser::IndividualRecord::addIndividualEvent (GEDCOMParser::
						      IndividualEvent *
						      const ie = 0)
{
  if (ie != 0)
    {
      _individual_events.push_back (SmartPtr < IndividualEvent > (ie));
    }
  else
    {
      _individual_events.push_back (SmartPtr < IndividualEvent >
				    (new IndividualEvent));
    }
  return _individual_events.back ().getPtr ();
}

GEDCOMParser::IndividualAttribute *
  GEDCOMParser::IndividualRecord::addIndividualAttribute (GEDCOMParser::
							  IndividualAttribute
							  * const data = 0)
{
  GEDCOMParser::IndividualAttribute * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createIndividualAttribute ();
    }
  _individual_attributes.push_back (SmartPtr < IndividualAttribute >
				    (tmp_data));
  return _individual_attributes.back ().getPtr ();
}

GEDCOMParser::LdsIndividualOrdinance *
  GEDCOMParser::IndividualRecord::addLdsIndividualOrdinance (GEDCOMParser::
							     LdsIndividualOrdinance
							     * const data = 0)
{
  GEDCOMParser::LdsIndividualOrdinance * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createLdsIndividualOrdinance ();
    }
  _lds_individual_ordinances.push_back (SmartPtr < LdsIndividualOrdinance >
					(tmp_data));
  return _lds_individual_ordinances.back ().getPtr ();
}

GEDCOMParser::ChildToFamilyLink *
  GEDCOMParser::IndividualRecord::addChildToFamilyLink (GEDCOMParser::
							ChildToFamilyLink *
							const data = 0)
{
  GEDCOMParser::ChildToFamilyLink * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createChildToFamilyLink ();
    }
  _child_to_family_links.push_back (SmartPtr < ChildToFamilyLink >
				    (tmp_data));
  return _child_to_family_links.back ().getPtr ();
}

void
GEDCOMParser::IndividualRecord::RemoveChildToFamilyLink (SmartPtr <
							 GEDCOMParser::
							 ChildToFamilyLink >
							 const &data)
{
  GEDCOMParser::ChildToFamilyLinks_t::iterator iter =
    find (_child_to_family_links.begin (), _child_to_family_links.end (),
	  data);
  if (iter != _child_to_family_links.end ())
    {
      _child_to_family_links.erase (iter);
    }
  return;
}

GEDCOMParser::SpouseToFamilyLink *
  GEDCOMParser::IndividualRecord::addSpouseToFamilyLink (GEDCOMParser::
							 SpouseToFamilyLink *
							 const data = 0)
{
  GEDCOMParser::SpouseToFamilyLink * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSpouseToFamilyLink ();
    }
  _spouse_to_family_links.push_back (SmartPtr < SpouseToFamilyLink >
				     (tmp_data));
  return _spouse_to_family_links.back ().getPtr ();
}

void
GEDCOMParser::IndividualRecord::RemoveSpouseToFamilyLink (SmartPtr <
							  GEDCOMParser::
							  SpouseToFamilyLink >
							  const &data)
{
  GEDCOMParser::SpouseToFamilyLinks_t::iterator iter =
    find (_spouse_to_family_links.begin (), _spouse_to_family_links.end (),
	  data);
  if (iter != _spouse_to_family_links.end ())
    {
      _spouse_to_family_links.erase (iter);
    }
  return;
}

void
GEDCOMParser::IndividualRecord::addSubmXref (std::string const &value)
{
  _subm_xrefs.push_back (std::string (value));
  return;
}

GEDCOMParser::Association *
  GEDCOMParser::IndividualRecord::addAssociation (GEDCOMParser::Association *
						  const data = 0)
{

  GEDCOMParser::Association * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createAssociation ();
    }
  _associations.push_back (SmartPtr < Association > (tmp_data));
  return _associations.back ().getPtr ();
}

void
GEDCOMParser::IndividualRecord::addAliaXref (std::string const &value)
{
  _alia_xrefs.push_back (std::string (value));
  return;
}

void
GEDCOMParser::IndividualRecord::addAnciXref (std::string const &value)
{
  _anci_xrefs.push_back (std::string (value));
  return;
}

void
GEDCOMParser::IndividualRecord::addDesiXref (std::string const &value)
{
  _desi_xrefs.push_back (std::string (value));
  return;
}

void
GEDCOMParser::IndividualRecord::setRfn (std::string const &value)
{
  _rfn = value;
  return;
}

void
GEDCOMParser::IndividualRecord::setAfn (std::string const &value)
{
  _afn = value;
  return;
}

GEDCOMParser::IndividualRecord::~IndividualRecord (void)
{
}

GEDCOMParser::AliaXrefs_t const &
GEDCOMParser::IndividualRecord::getAliaXrefs (void) const
{
  return _alia_xrefs;
}

GEDCOMParser::AnciXrefs_t const &
GEDCOMParser::IndividualRecord::getAnciXrefs (void) const
{
  return _anci_xrefs;
}

GEDCOMParser::DesiXrefs_t const &
GEDCOMParser::IndividualRecord::getDesiXrefs (void) const
{
  return _desi_xrefs;
}

GEDCOMParser::SubmXrefs_t const &
GEDCOMParser::IndividualRecord::getSubmXrefs (void) const
{
  return _subm_xrefs;
}

GEDCOMParser::PersonalNames_t const &
GEDCOMParser::IndividualRecord::getPersonalNames (void) const
{
  return _personal_names;
}

GEDCOMParser::IndividualEvents_t const &
GEDCOMParser::IndividualRecord::getIndividualEvents (void) const
{
  return _individual_events;
}

GEDCOMParser::IndividualAttributes_t const &
GEDCOMParser::IndividualRecord::getIndividualAttributes (void) const
{
  return _individual_attributes;
}

GEDCOMParser::LdsIndividualOrdinances_t const &
GEDCOMParser::IndividualRecord::getLdsIndividualOrdinances (void) const
{
  return _lds_individual_ordinances;
}


GEDCOMParser::ChildToFamilyLinks_t const &
GEDCOMParser::IndividualRecord::getChildToFamilyLinks (void) const
{
  return _child_to_family_links;
}

GEDCOMParser::SpouseToFamilyLinks_t const &
GEDCOMParser::IndividualRecord::getSpouseToFamilyLinks (void) const
{
  return _spouse_to_family_links;
}

GEDCOMParser::Associations_t const &
GEDCOMParser::IndividualRecord::getAssociations (void) const
{
  return _associations;
}

std::string const &
GEDCOMParser::IndividualRecord::getId (void) const
{
  return _id;
}


std::string const &
GEDCOMParser::IndividualRecord::getResn (void) const
{
  return _resn;
}

std::string const &
GEDCOMParser::IndividualRecord::getSex (void) const
{
  return _sex;
}


std::string const &
GEDCOMParser::IndividualRecord::getRfn (void) const
{
  return _rfn;
}

std::string const &
GEDCOMParser::IndividualRecord::getAfn (void) const
{
  return _afn;
}

void
GEDCOMParser::IndividualRecord::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitIndividualRecord (this);
  return;
}
