/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_INDIVIDUAL_EVENT_HH_
#define _GEDCOMPARSER_INDIVIDUAL_EVENT_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/EventDetailManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 INDIVIDUAL_EVENT_STRUCTURE structure 
  class IndividualEvent:public GEDCOMElement, public EventDetailManager
  {
  public:
    /// @memo Implements the GEDCOM 5.5 EVENT_TYPE_INDIVIDUAL enumeration (typedef'd to enumIndividualEvents)
    enum _enumIndividualEvents
    {
      ///
      e_None,
      ///
      e_Birt,
      ///
      e_Chr,
      ///
      e_Deat,
      ///
      e_Buri,
      ///
      e_Crem,
      ///
      e_Adop,
      ///
      e_Bapm,
      ///
      e_Barm,
      ///
      e_Basm,
      ///
      e_Bles,
      ///
      e_Chra,
      ///
      e_Conf,
      ///
      e_Fcom,
      ///
      e_Ordn,
      ///
      e_Natu,
      ///
      e_Emig,
      ///
      e_Immi,
      ///
      e_Cens,
      ///
      e_Prob,
      ///
      e_Will,
      ///
      e_Grad,
      ///
      e_Reti,
      ///
      e_Even
	///
    };
    ///
    typedef enum _enumIndividualEvents enumIndividualEvents;

      ///
      IndividualEvent (enumIndividualEvents type = e_None):_type (type),
      _famc_xref (), _adop ()
    {
    };
      ///
      IndividualEvent (IndividualEvent const &i):_type (i._type),
      _famc_xref (i._famc_xref), _adop (i._adop)
    {
    };
    ///
    virtual ~ IndividualEvent (void)
    {
    };
    ///@name Accessors (set) 
    //@{    
    ///
    void setType (enumIndividualEvents);
    ///
    void setFamcXref (std::string const &);
    ///
    void setAdop (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    ///returns the type
    virtual enumIndividualEvents getRawType (void) const;
    ///returns the type formatted as a string (translated in the expected locale)
    virtual std::string const getType (void) const;
    ///
    virtual std::string const &getFamcXref (void) const;
    ///
    virtual std::string const &getAdop (void) const;
    ///
    //@}

    /// operator == used to find an event by its type
    friend bool operator== (IndividualEvent const &eve, int type)
    {
      return (eve._type == (IndividualEvent::enumIndividualEvents) type);
    };
    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
    ///
    enumIndividualEvents _type;
    ///
    std::string _famc_xref;
    ///
    std::string _adop;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many individual events
  typedef std::vector < SmartPtr < IndividualEvent > >IndividualEvents_t;
  //@} 
};
#endif
