/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_INDIVIDUAL_ATTRIBUTE_HH_
#define _GEDCOMPARSER_INDIVIDUAL_ATTRIBUTE_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/EventDetailManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 INDIVIDUAL_ATTRIBUTE_STRUCTURE structure 
  class IndividualAttribute:public GEDCOMElement, public EventDetailManager
  {
  public:
    /// @memo Implements the GEDCOM 5.5 ATTRIBUTE_TYPE enumeration (typedef'd to enumIndividualAttributes)
    enum _enumIndividualAttributes
    {
      e_None,
      ///
      e_Cast,
      ///
      e_Dscr,
      ///
      e_Educ,
      ///
      e_Idno,
      ///
      e_Nati,
      ///
      e_Nchi,
      ///
      e_Nmr,
      ///
      e_Occu,
      ///
      e_Prop,
      ///
      e_Reli,
      ///
      e_Resi,
      ///
      e_Ssn,
      ///
      e_Titl
	///
    };
    ///
    typedef enum _enumIndividualAttributes enumIndividualAttributes;

      ///
      IndividualAttribute (enumIndividualAttributes type =
			   e_None):_type (type), _value ()
    {
    };
      ///
      IndividualAttribute (IndividualAttribute const &i):_type (i._type),
      _value (i._value)
    {
    }
    ///
    virtual ~ IndividualAttribute (void)
    {
    }
    ///@name Accessors (set) 
    //@{
    void setType (enumIndividualAttributes);
    ///
    void setValue (std::string const &);
    ///
    //@}

    ///@name Accessors (get)
    //@{     
    enumIndividualAttributes getRawType (void) const;
    ///
    std::string const getType (void) const;
    ///
    virtual std::string const &getValue (void) const;
    ///
    //@}

    /// operator == used to find an attribute by its type
    friend bool operator== (IndividualAttribute const &att, int type)
    {
      return (att._type ==
	      (IndividualAttribute::enumIndividualAttributes) type);
    };
    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
    ///
    enumIndividualAttributes _type;
    ///
    std::string _value;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many individual attributes
  typedef std::vector < SmartPtr < IndividualAttribute >
    >IndividualAttributes_t;
  //@}
};
#endif
