/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "IndividualAttribute.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)

void
GEDCOMParser::IndividualAttribute::setType (enumIndividualAttributes type)
{
  _type = type;
  return;
}

void
GEDCOMParser::IndividualAttribute::setValue (std::string const &value)
{
  _value = value;
  return;
}

GEDCOMParser::IndividualAttribute::enumIndividualAttributes GEDCOMParser::
  IndividualAttribute::getRawType (void) const
{
  return _type;
}

std::string const
GEDCOMParser::IndividualAttribute::getType (void) const
{
  std::string res;
  switch (_type)
    {
    case e_None:
      res = (_("None"));
      break;
    case e_Cast:
      res = (_("Caste"));
      break;
    case e_Dscr:
      res = (_("Physical description"));
      break;
    case e_Educ:
      res = (_("Level of education"));
      break;
    case e_Idno:
      res = (_("Identification number"));
      break;
    case e_Nati:
      res = (_("Nationality"));
      break;
    case e_Nchi:
      res = (_("Number of children"));
      break;
    case e_Nmr:
      res = (_("Number of marriages"));
      break;
    case e_Occu:
      res = (_("Occupation"));
      break;
    case e_Prop:
      res = (_("Property"));
      break;
    case e_Reli:
      res = (_("Religion"));
      break;
    case e_Resi:
      res = (_("Residence"));
      break;
    case e_Ssn:
      res = (_("Social security number"));
      break;
    case e_Titl:
      res = (_("Title"));
      break;
    default:
      res = (_("Unmanaged attribute"));
      break;
    }
  return res;
}

std::string const &
GEDCOMParser::IndividualAttribute::getValue (void) const
{
  return _value;
}

void
GEDCOMParser::IndividualAttribute::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitIndividualAttribute (this);
  return;
}
