/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "Header.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

#include "config.h"

void
GEDCOMParser::Header::setSour (std::string const &value)
{
  _sour = value;
  return;
}

void
GEDCOMParser::Header::setVers (std::string const &value)
{
  _vers = value;
  return;
}

void
GEDCOMParser::Header::setName (std::string const &value)
{
  _name = value;
  return;
}

void
GEDCOMParser::Header::setCorp (std::string const &value)
{
  _corp = value;
  return;
}

GEDCOMParser::Data * GEDCOMParser::Header::setData (GEDCOMParser::Data *
						    const data = 0)
{
  GEDCOMParser::Data * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createData ();
    }
  _data = SmartPtr < Data > (tmp_data);
  return _data.getPtr ();
}

void
GEDCOMParser::Header::setDest (std::string const &value)
{
  _dest = value;
  return;
}

void
GEDCOMParser::Header::setDate (std::string const &value)
{
  if (_date != 0)
    {
      delete
	_date;
      _date = 0;
    }
  _date = new GEDCOMParser::DateManagement::DateValue (value);
  return;
}

void
GEDCOMParser::Header::setTime (std::string const &value)
{
  _time = value;
  return;
}

void
GEDCOMParser::Header::setSubm (std::string const &value)
{
  _subm = value;
  return;
}

void
GEDCOMParser::Header::setSubn (std::string const &value)
{
  _subn = value;
  return;
}

void
GEDCOMParser::Header::setFile (std::string const &value)
{
  _file = value;
  return;
}

void
GEDCOMParser::Header::setCopr (std::string const &value)
{
  _copr = value;
  return;
}

void
GEDCOMParser::Header::setGedcVers (std::string const &value)
{
  _gedc_vers = value;
  return;
}

void
GEDCOMParser::Header::setGedcForm (std::string const &value)
{
  _gedc_form = value;
  return;
}

void
GEDCOMParser::Header::setCharset (std::string const &value)
{
  _charset = value;
  return;
}

void
GEDCOMParser::Header::setCharsetVersion (std::string const &value)
{
  _charset_vers = value;
  return;
}

void
GEDCOMParser::Header::setLang (std::string const &value)
{
  _lang = value;
  return;
}

void
GEDCOMParser::Header::setPlaceForm (std::string const &value)
{
  _place_form = value;
  return;
}

void
GEDCOMParser::Header::concNote (std::string const &value)
{
  _note = _note + value;
  return;
}

void
GEDCOMParser::Header::contNote (std::string const &value)
{
  _note = _note + "\n" + value;
  return;
}

void
GEDCOMParser::Header::setDefaults (void)
{
  _sour = PACKAGE;
  _vers = VERSION;
  _name = PACKAGE_NAME;
  _gedc_form = GEDC_FORM;
  _gedc_vers = GEDC_VERS;
  _charset = CHARSET;
  return;
}

SmartPtr < GEDCOMParser::Data > const &
GEDCOMParser::Header::getData (void) const
{
  return _data;
}

std::string const &
GEDCOMParser::Header::getSour (void) const
{
  return _sour;
}
std::string const &
GEDCOMParser::Header::getVers (void) const
{
  return _vers;
}

std::string const &
GEDCOMParser::Header::getName (void) const
{
  return _name;
}

std::string const &
GEDCOMParser::Header::getCorp (void) const
{
  return _corp;
}

std::string const &
GEDCOMParser::Header::getDest (void) const
{
  return _dest;
}

std::string const
GEDCOMParser::Header::getDate (void) const
{
  std::string res;
  if (_date != 0)
    {
      res = _date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const *const
GEDCOMParser::Header::getDateObject (void) const
{
  return _date;
}

std::string const &
GEDCOMParser::Header::getTime (void) const
{
  return _time;
}
std::string const &
GEDCOMParser::Header::getSubm (void) const
{
  return _subm;
}

std::string const &
GEDCOMParser::Header::getSubn (void) const
{
  return _subn;
}

std::string const &
GEDCOMParser::Header::getFile (void) const
{
  return _file;
}

std::string const &
GEDCOMParser::Header::getCopr (void) const
{
  return _copr;
}

std::string const &
GEDCOMParser::Header::getGedcVers (void) const
{
  return _gedc_vers;
}

std::string const &
GEDCOMParser::Header::getGedcForm (void) const
{
  return _gedc_form;
}

std::string const &
GEDCOMParser::Header::getCharset (void) const
{
  return _charset;
}

std::string const &
GEDCOMParser::Header::getCharsetVersion (void) const
{
  return _charset_vers;
}

std::string const &
GEDCOMParser::Header::getLang (void) const
{
  return _lang;
}

std::string const &
GEDCOMParser::Header::getPlaceForm (void) const
{
  return _place_form;
}

std::string const &
GEDCOMParser::Header::getNote (void) const
{
  return _note;
}

void
GEDCOMParser::Header::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitHeader (this);
  return;
}
