/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "FamilyRecord.hh"
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"


GEDCOMParser::FamilyRecord::FamilyRecord (std::string const &id = "")
{
  if (id != "")
    {
      setId (id);
    }
  return;
}

void
GEDCOMParser::FamilyRecord::setId (std::string const &value)
{
  _id = value;
  return;
}

GEDCOMParser::FamilyEvent *
  GEDCOMParser::FamilyRecord::addFamilyEvent (GEDCOMParser::FamilyEvent *
					      const data = 0)
{
  GEDCOMParser::FamilyEvent * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createFamilyEvent ();
    }
  _events.push_back (SmartPtr < FamilyEvent > (tmp_data));
  return _events.back ().getPtr ();
}

void
GEDCOMParser::FamilyRecord::setHusb (std::string const &value)
{
  _husb = value;
  return;
}

void
GEDCOMParser::FamilyRecord::setWife (std::string const &value)
{
  _wife = value;
  return;
}

void
GEDCOMParser::FamilyRecord::addChilXref (std::string const &value)
{
  _chil_xrefs.push_back (value);
  return;
}

void
GEDCOMParser::FamilyRecord::RemoveChilXref (std::string const &value)
{
  ChildXrefs_t::iterator iter =
    find (_chil_xrefs.begin (), _chil_xrefs.end (), value);
  _chil_xrefs.erase (iter);
  return;
}

void
GEDCOMParser::FamilyRecord::setNchi (std::string const &value)
{
  _nchi = value;
  return;
}

void
GEDCOMParser::FamilyRecord::setSubm (std::string const &value)
{
  _subm = value;
  return;
}

GEDCOMParser::LdsSpouseSealing *
  GEDCOMParser::FamilyRecord::addLdsSpouseSealing (GEDCOMParser::
						   LdsSpouseSealing *
						   const data = 0)
{
  GEDCOMParser::LdsSpouseSealing * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createLdsSpouseSealing ();
    }
  _lds_spouse_sealings.push_back (SmartPtr < LdsSpouseSealing > (tmp_data));
  return _lds_spouse_sealings.back ().getPtr ();
}

GEDCOMParser::FamilyRecord::~FamilyRecord (void)
{
}

GEDCOMParser::FamilyEvents_t const &
GEDCOMParser::FamilyRecord::getFamilyEvents (void) const
{
  return _events;
}

GEDCOMParser::ChildXrefs_t const &
GEDCOMParser::FamilyRecord::getChilXrefs (void) const
{
  return _chil_xrefs;
}

GEDCOMParser::LdsSpouseSealings_t const &
GEDCOMParser::FamilyRecord::getLdsSpouseSealings (void) const
{
  return _lds_spouse_sealings;
}

std::string const &
GEDCOMParser::FamilyRecord::getId (void) const
{
  return _id;
}

std::string const &
GEDCOMParser::FamilyRecord::getHusb (void) const
{
  return _husb;
}

std::string const &
GEDCOMParser::FamilyRecord::getWife (void) const
{
  return _wife;
}

std::string const &
GEDCOMParser::FamilyRecord::getNchi (void) const
{
  return _nchi;
}

std::string const &
GEDCOMParser::FamilyRecord::getSubm (void) const
{
  return _subm;
}

void
GEDCOMParser::FamilyRecord::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitFamilyRecord (this);
  return;
}
