/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "GEDCOMParser/DateManagement/Range.hh"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)

void
GEDCOMParser::DateManagement::Range::setType (enumRangeTypes type)
{
  _type = type;
  return;
}

void
GEDCOMParser::DateManagement::Range::setBound1 (GEDCOMParser::DateManagement::
						Date const &bound1)
{
  if ((_bound1 != 0) && (_bound1 != &bound1))
    {
      delete
	_bound1;
      _bound1 != 0;
    }
  if (_bound1 != &bound1)
    {
      _bound1 = new GEDCOMParser::DateManagement::Date (bound1);
    }
  return;
}

void
GEDCOMParser::DateManagement::Range::setBound2 (GEDCOMParser::DateManagement::
						Date const &bound2)
{
  if ((_bound2 != 0) && (_bound2 != &bound2))
    {
      delete
	_bound2;
      _bound2 != 0;
    }
  if (_bound2 != &bound2)
    {
      _bound2 = new GEDCOMParser::DateManagement::Date (bound2);
    }
  return;
}

std::string const
GEDCOMParser::DateManagement::Range::getDisplayValue (void) const
{
  std::string res;
  switch (_type)
    {
    case e_Before:
      if (_bound1 != 0)
	{
	  res = _("Before ") + _bound1->getDisplayValue ();
	}
      break;
    case e_After:
      if (_bound1 != 0)
	{
	  res = _("After ") + _bound1->getDisplayValue ();
	}
      break;
    case e_Between:
      if (_bound1 != 0)
	{
	  res = _("Between ") + _bound1->getDisplayValue ();
	}
      if (_bound2 != 0)
	{
	  res = res + _(" and ") + _bound2->getDisplayValue ();
	}
      break;
    default:
      res = _("Unknown range ");
      break;
    }
  return res;
}
