/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/DateManagement/datevalueparser_decl.hh"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)


GEDCOMParser::DateManagement::DateValue::DateValue (std::string const &value):
_raw_value (),
_type (e_Null),
_date (0),
_date_phrase (0),
_period (0),
_range (0)
{
  setValue (value);
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setType (enumDateValueTypes type)
{
  _type = type;
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setDate (GEDCOMParser::
						  DateManagement::
						  Date const &date)
{
  if ((_date != 0) && (_date != &date))
    {
      delete _date;
      _date = 0;
    }
  if (_date != &date)
    {
      _date = new GEDCOMParser::DateManagement::Date (date);
    }
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setDatePhrase (GEDCOMParser::
							DateManagement::
							DatePhrase const
							&date_phrase)
{
  if ((_date_phrase != 0) && (_date_phrase != &date_phrase))
    {
      delete _date_phrase;
      _date_phrase = 0;
    }
  if (_date_phrase != &date_phrase)
    {
      _date_phrase =
	new GEDCOMParser::DateManagement::DatePhrase (date_phrase);
    }
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setPeriod (GEDCOMParser::
						    DateManagement::
						    Period const &period)
{
  if ((_period != 0) && (_period != &period))
    {
      delete _period;
      _period = 0;
    }
  if (_period != &period)
    {
      _period = new GEDCOMParser::DateManagement::Period (period);
    }
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setRange (GEDCOMParser::
						   DateManagement::
						   Range const &range)
{
  if ((_range != 0) && (_range != &range))
    {
      delete _range;
      _range = 0;
    }
  if (_range != &range)
    {
      _range = new GEDCOMParser::DateManagement::Range (range);
    }
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setValue (std::string const &value)
{
  _raw_value = value;
  datevalue_runparse (value, this);
  return;
}

void
GEDCOMParser::DateManagement::DateValue::setParseError (bool val)
{
  _parsing_ko = val;
}

std::string const
GEDCOMParser::DateManagement::DateValue::getDisplayValue (void) const
{
  std::string res;
  if (_parsing_ko == true)
    {
      res = _raw_value;
    }
  else
    {
      switch (_type)
	{
	case e_Date:
	  if (_date != 0)
	    {
	      res = _date->getDisplayValue ();
	    }
	  break;
	case e_DatePhrase:
	  if (_date_phrase != 0)
	    {
	      res = _date_phrase->getDisplayValue ();
	    }
	  break;
	case e_Period:
	  if (_period != 0)
	    {
	      res = _period->getDisplayValue ();
	    }
	  break;
	case e_Range:
	  if (_range != 0)
	    {
	      res = _range->getDisplayValue ();
	    }
	  break;
	case e_Interpreted:
	  if (_date != 0)
	    {
	      res = _date->getDisplayValue ();
	    }
	  if (_date_phrase != 0)
	    {
	      res =
		res + _(" interpreted from ") +
		_date_phrase->getDisplayValue ();
	    }
	  break;
	default:
	  res = _("Unknown date value");
	  res = res + " (" + _raw_value + ")";
	  break;
	}
    }
  return res;
}

std::string const &
GEDCOMParser::DateManagement::DateValue::getRawValue (void) const
{
  return _raw_value;
}
