/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "GEDCOMParser/DateManagement/Date.hh"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)

void
GEDCOMParser::DateManagement::Date::setCalendar (enumCalendars cal)
{
  _calendar = cal;
  return;
}

void
GEDCOMParser::DateManagement::Date::setDay (std::string const &day)
{
  _day = day;
  return;
}

void
GEDCOMParser::DateManagement::Date::setMonth (enumMonths month)
{
  _month = month;
  return;
}

void
GEDCOMParser::DateManagement::Date::setYear (std::string const &year)
{
  _year = year;
  return;
}


void
GEDCOMParser::DateManagement::Date::setPrecision (enumPrecisionDateTypes prec)
{
  _precision = prec;
  return;
}

void
GEDCOMParser::DateManagement::Date::
setFrenchYearFormat (enumFrenchYearFormat format)
{
  _french_year_format = format;
  return;
}

void
GEDCOMParser::DateManagement::Date::setBeforeChrist (bool val)
{
  _before_christ = val;
  return;
}

std::string const
GEDCOMParser::DateManagement::Date::getDisplayValue (void) const
{
  std::string res;
  std::string month;
  std::string year;
  std::string precision;

  year = _year;

  switch (_calendar)
    {
    case e_French:
      {
	if (_french_year_format == e_FrenchYearFormat_Roman)
	  {
	    year = _("AN ") + year;
	  }
      }
      break;
    default:
      break;
    };
  switch (_month)
    {
    case e_Jan:
      month = _("Jan");
      break;
    case e_Feb:
      month = _("Feb");
      break;
    case e_Mar:
      month = _("Mar");
      break;
    case e_Apr:
      month = _("Apr");
      break;
    case e_May:
      month = _("May");
      break;
    case e_Jun:
      month = _("Jun");
      break;
    case e_Jul:
      month = _("Jul");
      break;
    case e_Aug:
      month = _("Aug");
      break;
    case e_Sep:
      month = _("Sep");
      break;
    case e_Oct:
      month = _("Oct");
      break;
    case e_Nov:
      month = _("Nov");
      break;
    case e_Dec:
      month = _("Dec");
      break;
    case e_Hebr_Tsh:
      month = _("Tsh");
      break;
    case e_Hebr_Csh:
      month = _("Csh");
      break;
    case e_Hebr_Ksl:
      month = _("Ksl");
      break;
    case e_Hebr_Tvt:
      month = _("Tvt");
      break;
    case e_Hebr_Shv:
      month = _("Shv");
      break;
    case e_Hebr_Adr:
      month = _("Adr");
      break;
    case e_Hebr_Ads:
      month = _("Ads");
      break;
    case e_Hebr_Nsn:
      month = _("Nsn");
      break;
    case e_Hebr_Iyr:
      month = _("Iyr");
      break;
    case e_Hebr_Svn:
      month = _("Svn");
      break;
    case e_Hebr_Tmz:
      month = _("Tmz");
      break;
    case e_Hebr_Aav:
      month = _("Aav");
      break;
    case e_Hebr_Ell:
      month = _("Ell");
      break;
    case e_Fren_Vend:
      month = _("Vend");
      break;
    case e_Fren_Brum:
      month = _("Brum");
      break;
    case e_Fren_Frim:
      month = _("Frim");
      break;
    case e_Fren_Nivo:
      month = _("Nivo");
      break;
    case e_Fren_Pluv:
      month = _("Pluv");
      break;
    case e_Fren_Vent:
      month = _("Vent");
      break;
    case e_Fren_Germ:
      month = _("Germ");
      break;
    case e_Fren_Flor:
      month = _("Flor");
      break;
    case e_Fren_Prai:
      month = _("Prai");
      break;
    case e_Fren_Mess:
      month = _("Mess");
      break;
    case e_Fren_Ther:
      month = _("Ther");
      break;
    case e_Fren_Fruc:
      month = _("Fruc");
      break;
    case e_Fren_Comp:
      month = _("Comp");
      break;
    default:
      month = "";
      break;
    }

  switch (_precision)
    {
    case e_About:
      precision = _("About ");
      break;
    case e_Calculated:
      precision = _("(calculated) ");
      break;
    case e_Estimated:
      precision = _("(estimated) ");
      break;
    default:
      break;
    }
  std::string day_month_separator;
  std::string month_year_separator;

  if ((_day != "") && (month != ""))
    {
      day_month_separator = " ";
    }
  if ((month != "") && (year != ""))
    {
      month_year_separator = " ";
    }

  res =
    precision + _day + day_month_separator + month + month_year_separator +
    year;

  if (_before_christ == true)
    {
      res = res + _(" B.C.");
    }
  return res;
}
