/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "Data.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"

void
GEDCOMParser::Data::setData (std::string const &value)
{
  _data = value;
  return;
}

void
GEDCOMParser::Data::setDate (std::string const &value)
{
  if (_date != 0)
    {
      delete
	_date;
      _date = 0;
    }
  _date = new GEDCOMParser::DateManagement::DateValue (value);
  return;
}

void
GEDCOMParser::Data::setCopr (std::string const &value)
{
  _copr = value;
  return;
}

std::string const &
GEDCOMParser::Data::getData (void) const
{
  return _data;
}

std::string const
GEDCOMParser::Data::getDate (void) const
{
  std::string res;
  if (_date != 0)
    {
      res = _date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const *const
GEDCOMParser::Data::getDateObject (void) const
{
  return _date;
}

std::string const &
GEDCOMParser::Data::getCopr (void) const
{
  return _copr;
}

void
GEDCOMParser::Data::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitData (this);
  return;
}
