/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_CHILD_TO_FAMILY_LINK_HH_
#define _GEDCOMPARSER_CHILD_TO_FAMILY_LINK_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/FamilyLink.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  ///@name typedefs
  //@{
  /// @doc handling of pedis
  typedef std::vector < std::string > Pedis_t;
  //@}
  /// @memo Implements the GEDCOM 5.5 CHILD_TO_FAMILY_LINK structure 
  class ChildToFamilyLink:public FamilyLink
  {
  public:
    virtual ~ ChildToFamilyLink (void)
    {
    };
    ///@name Accessors (set) 
    //@{
    ///
    void addPedi (std::string const &);
    //@}    
    ///@name Accessors (get)
    //@{ 
    ///
    Pedis_t const &getPedis (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
    ///
    class IsEqualByFamXref
    {
    public:
      IsEqualByFamXref (std::string const &xref):_xref (xref)
      {
      };
        std::string _xref;
      bool operator      () (SmartPtr < GEDCOMParser::ChildToFamilyLink >
			     const &link)
      {
	return _xref == link->getFamXref ();
      };
    };
  protected:
    Pedis_t _pedis;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many childtofamilylinks
  typedef std::vector < SmartPtr < ChildToFamilyLink > >ChildToFamilyLinks_t;
  //@}
};
#endif
