/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_CHANGE_DATE_HH_
#define _GEDCOMPARSER_CHANGE_DATE_HH_

#include <string>
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 CHANGE_DATE structure 
  class ChangeDate:public GEDCOMElement, public AttachmentManager
  {
  protected:
    GEDCOMParser::DateManagement::DateValue * _date;
    std::string _time;
  public:
    ChangeDate (void):_date (0), _time ()
    {
    };
      ChangeDate (ChangeDate const &c):_date (0), _time (c._time)
    {
      if (c._date != 0)
	{
	  _date = new GEDCOMParser::DateManagement::DateValue (*c._date);
	}
      return;
    };
    virtual ~ ChangeDate (void)
    {
      delete _date;
      _date = 0;
      return;
    };
    ///@name Accessors (set) 
    //@{
    void setDate (std::string const &);
    ///
    void setTime (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{ 
    virtual std::string const getDate (void) const;
    ///
    GEDCOMParser::DateManagement::
      DateValue const *const getDateObject (void) const;
    ///
    virtual std::string const &getTime (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
