/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/MultimediaLink.hh"
#include "GEDCOMParser/NoteStructure.hh"
#include "GEDCOMParser/SourceCitation.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"


GEDCOMParser::Attachment *
  GEDCOMParser::AttachmentManager::addAttachment (GEDCOMParser::Attachment *
						  const data)
{
  _attachments.push_back (SmartPtr < GEDCOMParser::Attachment > (data));
  GEDCOMParser::MultimediaLink * const
    multimedia_link_data =
    static_cast <
    MultimediaLink * const >(data);
  if (multimedia_link_data != 0)
    {
      _multimedia_links.push_back (multimedia_link_data);
    }
  else
    {
      GEDCOMParser::NoteStructure * const
	note_structure_data =
	static_cast <
	NoteStructure * const >(data);
      if (note_structure_data != 0)
	{
	  _note_structures.push_back (note_structure_data);
	}
      else
	{
	  GEDCOMParser::SourceCitation * const
	    source_citation_data =
	    static_cast <
	    SourceCitation * const >(data);
	  if (source_citation_data != 0)
	    {
	      _source_citations.push_back (source_citation_data);
	    }
	}
    }
  return data;
}

GEDCOMParser::Attachment *
  GEDCOMParser::AttachmentManager::addAttachment (SmartPtr <
						  GEDCOMParser::Attachment >
						  const &data)
{
  GEDCOMParser::Attachment * const
    data_ptr =
    data.
    getPtr ();
  _attachments.push_back (data);
  GEDCOMParser::MultimediaLink * const
    multimedia_link_data =
    static_cast <
    MultimediaLink * const >(data_ptr);
  if (multimedia_link_data != 0)
    {
      _multimedia_links.push_back (multimedia_link_data);
    }
  else
    {
      GEDCOMParser::NoteStructure * const
	note_structure_data =
	static_cast <
	NoteStructure * const >(data_ptr);
      if (note_structure_data != 0)
	{
	  _note_structures.push_back (note_structure_data);
	}
      else
	{
	  GEDCOMParser::SourceCitation * const
	    source_citation_data =
	    static_cast <
	    SourceCitation * const >(data_ptr);
	  if (source_citation_data != 0)
	    {
	      _source_citations.push_back (source_citation_data);
	    }
	}
    }
  return data_ptr;
}


GEDCOMParser::MultimediaLink *
  GEDCOMParser::AttachmentManager::addMultimediaLink (GEDCOMParser::
						      MultimediaLink *
						      const data)
{
  GEDCOMParser::MultimediaLink * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createMultimediaLink ();
    }
  _multimedia_links.push_back (tmp_data);
  _attachments.push_back (SmartPtr < Attachment > (tmp_data));
  return tmp_data;
}

GEDCOMParser::NoteStructure *
  GEDCOMParser::AttachmentManager::addNoteStructure (GEDCOMParser::
						     NoteStructure *
						     const data)
{
  GEDCOMParser::NoteStructure * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createNoteStructure ();
    }
  _note_structures.push_back (tmp_data);
  _attachments.push_back (SmartPtr < Attachment > (tmp_data));
  return tmp_data;
}

GEDCOMParser::SourceCitation *
  GEDCOMParser::AttachmentManager::addSourceCitation (GEDCOMParser::
						      SourceCitation *
						      const data)
{
  GEDCOMParser::SourceCitation * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSourceCitation ();
    }
  _source_citations.push_back (tmp_data);
  _attachments.push_back (SmartPtr < Attachment > (tmp_data));
  return tmp_data;
}

GEDCOMParser::Attachments_t const &
GEDCOMParser::AttachmentManager::getAttachments (void) const
{
  return _attachments;
}

GEDCOMParser::AttachmentManager::MultimediaLinks_t const &
GEDCOMParser::AttachmentManager::getMultimediaLinks (void) const
{
  return _multimedia_links;
}

GEDCOMParser::AttachmentManager::NoteStructures_t const &
GEDCOMParser::AttachmentManager::getNoteStructures (void) const
{
  return _note_structures;
}

GEDCOMParser::AttachmentManager::SourceCitations_t const &
GEDCOMParser::AttachmentManager::getSourceCitations (void) const
{
  return _source_citations;
}

void
GEDCOMParser::AttachmentManager::removeAttachment (GEDCOMParser::Attachment *
						   const data)
{
  GEDCOMParser::Attachments_t::iterator iter =
    std::find (_attachments.begin (), _attachments.end (), data);
  if (iter != _attachments.end ())
    {
      _attachments.erase (iter);
      GEDCOMParser::MultimediaLink * const
	multimedia_link_data =
	static_cast <
	MultimediaLink * const >(data);
      if (multimedia_link_data != 0)
	{
	  GEDCOMParser::AttachmentManager::MultimediaLinks_t::
	    iterator multimedia_link_iter =
	    std::find (_multimedia_links.begin (), _multimedia_links.end (),
		       multimedia_link_data);
	  if (multimedia_link_iter != _multimedia_links.end ())
	    {
	      _multimedia_links.erase (multimedia_link_iter);
	    }
	}
      else
	{
	  GEDCOMParser::NoteStructure * const
	    note_structure_data =
	    static_cast <
	    NoteStructure * const >(data);
	  if (note_structure_data != 0)
	    {
	      GEDCOMParser::AttachmentManager::NoteStructures_t::
		iterator note_structure_iter =
		std::find (_note_structures.begin (), _note_structures.end (),
			   note_structure_data);
	      if (note_structure_iter != _note_structures.end ())
		{
		  _note_structures.erase (note_structure_iter);
		}
	    }
	  else
	    {
	      GEDCOMParser::SourceCitation * const
		source_citation_data =
		static_cast <
		SourceCitation * const >(data);
	      if (source_citation_data != 0)
		{
		  GEDCOMParser::AttachmentManager::SourceCitations_t::
		    iterator source_citation_iter =
		    std::find (_source_citations.begin (),
			       _source_citations.end (),
			       source_citation_data);
		  if (source_citation_iter != _source_citations.end ())
		    {
		      _source_citations.erase (source_citation_iter);
		    }
		}
	    }
	}

    }
  return;
}

void
GEDCOMParser::AttachmentManager::removeMultimediaLink (GEDCOMParser::
						       MultimediaLink *
						       const data)
{
  removeAttachment (data);
  return;
}

void
GEDCOMParser::AttachmentManager::removeMultimediaLink (std::
						       string const
						       &obje_xref)
{
  GEDCOMParser::AttachmentManager::MultimediaLinks_t::iterator iter =
    std::find (_multimedia_links.begin (), _multimedia_links.end (),
	       obje_xref);
  if (iter != _multimedia_links.end ())
    {
      removeAttachment (*iter);
    }
  return;
}

void
GEDCOMParser::AttachmentManager::removeNoteStructure (GEDCOMParser::
						      NoteStructure *
						      const data)
{
  removeAttachment (data);
  return;
}

void
GEDCOMParser::AttachmentManager::removeNoteStructure (std::
						      string const &note_xref)
{
  GEDCOMParser::AttachmentManager::NoteStructures_t::iterator iter =
    std::find (_note_structures.begin (), _note_structures.end (), note_xref);
  if (iter != _note_structures.end ())
    {
      removeAttachment (*iter);
    }
  return;
}

void
GEDCOMParser::AttachmentManager::removeSourceCitation (GEDCOMParser::
						       SourceCitation *
						       const data)
{
  removeAttachment (data);
  return;
}

void
GEDCOMParser::AttachmentManager::removeSourceCitation (std::
						       string const
						       &source_xref)
{
  GEDCOMParser::AttachmentManager::SourceCitations_t::iterator iter =
    std::find (_source_citations.begin (), _source_citations.end (),
	       source_xref);
  if (iter != _source_citations.end ())
    {
      removeAttachment (*iter);
    }
  return;
}
