/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "GEDCOMParser/Association.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::Association::addIndiXref (std::string const &value)
{
  _indi_xrefs.push_back (value);
  return;
}

void
GEDCOMParser::Association::setType (std::string const &value)
{
  _type = value;
  return;
}

void
GEDCOMParser::Association::setRela (std::string const &value)
{
  _rela = value;
  return;
}

GEDCOMParser::IndiXrefs_t const &
GEDCOMParser::Association::getIndiXrefs (void) const
{
  return _indi_xrefs;
}

std::string const &
GEDCOMParser::Association::getType (void) const
{
  return _type;
}

std::string const &
GEDCOMParser::Association::getRela (void) const
{
  return _rela;
}

void
GEDCOMParser::Association::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitAssociation (this);
  return;
}
