/* 
   Copyright 2002 Cyril Picard

   This file is part of the GEDCOMParser library 
   (developed within the Genealogy Free Software Tools project).

   The GEDCOMParser library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   The GEDCOMParser library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the GEDCOMParser library ; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMHelper/EventDetailManagerHelper.hh"
#include <iostream>

std::string GEDCOMHelper::EventDetailManagerHelper::getDate (void) const
{
  std::string res;
  if (_event != 0)
    {
      SmartPtr < GEDCOMParser::Event > const &
	event_detail =
	_event->
	getEvent ();
      if (!event_detail.Null ())
	{
	  res = event_detail->getDate ();
	}
    }
  return res;
}

std::string GEDCOMHelper::EventDetailManagerHelper::getPlace (void) const
{
  std::string res;
  if (_event != 0)
    {
      SmartPtr < GEDCOMParser::Event > const &
	event_detail =
	_event->
	getEvent ();
      if (!event_detail.Null ())
	{
	  SmartPtr < GEDCOMParser::Place > const &
	    place =
	    event_detail->
	    getPlace ();
	  if (!place.Null ())
	    {
	      res = place->getPlaceValue ();
	    }
	}
    }
  return res;
}

void
GEDCOMHelper::EventDetailManagerHelper::setDate (std::string const &date)
{
  if (_event != 0)
    {
      SmartPtr < GEDCOMParser::Event > event_detail = _event->getEvent ();
      if (event_detail.Null ())
	{
	  _event->setEvent ();
	  event_detail = _event->getEvent ();
	}
      event_detail->setDate (date);
    }
  return;
}

void
GEDCOMHelper::EventDetailManagerHelper::setPlace (std::string const &location)
{
  if (_event != 0)
    {
      SmartPtr < GEDCOMParser::Event > event_detail = _event->getEvent ();
      if (event_detail.Null ())
	{
	  _event->setEvent ();
	  event_detail = _event->getEvent ();
	}
      SmartPtr < GEDCOMParser::Place > place = event_detail->getPlace ();
      if (place.Null ())
	{
	  event_detail->setPlace ();
	  place = event_detail->getPlace ();
	}
      place->setPlaceValue (location);
    }
  return;
}
