/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _WIDGET_NOTE_HH_
#define _WIDGET_NOTE_HH_

#include <gtk--/menubar.h>
#include <gtk--/menuitem.h>
#include <gtk--/pixmap.h>
#include <gtk--/text.h>

#include "patterns/SmartPtr.hh"

#include <string>
#include <vector>

class WidgetNote : public Gtk::MenuBar
{
public:
  WidgetNote(void);
  ~WidgetNote(void);
  void add_text(std::string const &);
  void clear(void);
private:
  class TextNoteMenuItem : public Gtk::MenuItem
  {
  public:
    TextNoteMenuItem(void);
    void set_text(std::string const &);
    void clear(void);
  private:
    Gtk::Text * _text;
  }; //class TextNoteMenuItem
  class PixmapNoteMenuItem : public Gtk::MenuItem
  {
  public:
    PixmapNoteMenuItem(void);
    void set_text(void);
    void clear(void);
  private:
    Gtk::Pixmap * _pixmap;
  };
  Gtk::Menu * _submenu;
  std::vector< SmartPtr < TextNoteMenuItem > > _texts;
  PixmapNoteMenuItem * _pixmap;
}; // class WidgetNote

#endif
