/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "Options.hh"
#include <gnome--.h>
#include "libgnome/gnome-config.h"

int Options::getIntOption(std::string section, std::string key)
{
  int result = -1;
  
  Gnome::Client* client = Gnome::Client::master_client(); 
  if (client != 0)
    {
      std::string config_prefix = client->get_config_prefix();
      config_prefix += section;
      gnome_config_push_prefix(std::string(config_prefix + "/").c_str());
      result = gnome_config_get_int(key.c_str());
      gnome_config_pop_prefix();
    }    
  return result;
}
