/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/ViewTreeBrowser.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"

BakeryGateway::ViewTreeBrowser::ViewTreeBrowser(void) :
  _root_individu()
{
  _mmi_browser.getTree()->selection_changed.connect(slot(this, &ViewTreeBrowser::SelectionChanged));
  return;
}

void BakeryGateway::ViewTreeBrowser::AddParentInTree(GEDCOMParser::IndividualRecord  * const child, std::string const &sex, std::vector<GEDCOMParser::IndividualRecord *> * children)
{
  std::string individu_name;
  GEDCOMParser::IndividualRecord * parent = 0;
  GEDCOMHelper::IndividualRecordHelper helper(child, get_document());

  parent = helper.getIndividualParent(sex);
		  
  if (parent != 0)
    {
      individu_name = getIndividualName(parent);
      if (_mmi_browser.addParent(child->getId(), parent->getId(), individu_name) == 1)
	{
	  children->push_back(parent);
	}
    }
  return;
}

std::string const BakeryGateway::ViewTreeBrowser::getIndividualName(GEDCOMParser::IndividualRecord const * const individual)
{
  std::string individual_name;
  if (individual->getPersonalNames().size() > 0)
    {
      individual_name = individual->getPersonalNames()[0]->getName();
    }
  else
    {
      individual_name = "";
    }
  return individual_name;
}

void BakeryGateway::ViewTreeBrowser::Load(void)
{
  _mmi_browser.clear();
  GEDCOMParser::IndividualRecords_t const &individuals = get_document()->getIndividualRecords();
  std::vector<GEDCOMParser::IndividualRecord *> children;
  std::vector<GEDCOMParser::IndividualRecord *> * tmp_children = 0;
  if (individuals.size() > 0)
    {
      if (_parent_entity != 0)
	{
	  if (_root_individu.Null())
	    {
	      GEDCOMParser::IndividualRecords_t::const_iterator root_iter = individuals.find(_parent_entity->getId());
	      if (root_iter != individuals.end())
		{
		  _root_individu = root_iter->second;
		}
	    }
	  else
	    {
	      // check if _root_individu exists in the current document
	      GEDCOMParser::IndividualRecords_t::const_iterator root_iter = individuals.find(_root_individu->getId());
	      if (root_iter == individuals.end())
		{
		  GEDCOMParser::IndividualRecords_t::const_iterator root_iter2 = individuals.find(_parent_entity->getId());
		  if (root_iter2 != individuals.end())
		    {
		      _root_individu = root_iter2->second;
		    }
		}
	      else
		{
		  if (_root_individu.getPtr() != root_iter->second.getPtr())
		    {
		      GEDCOMParser::IndividualRecords_t::const_iterator root_iter2 = individuals.find(_parent_entity->getId());
		      if (root_iter2 != individuals.end())
			{
			  _root_individu = root_iter2->second;
			}
		    }
		}
	    }
	  GEDCOMParser::IndividualRecord * child = _root_individu.getPtr();
	  std::string individu_name;

	  individu_name  = getIndividualName(child);
	  _mmi_browser.addParent("", child->getId(), individu_name);
	  children.push_back(child);

	  while (children.size() > 0)
	    {
	      tmp_children = new std::vector<GEDCOMParser::IndividualRecord *>;
	      for (std::vector<GEDCOMParser::IndividualRecord *>::const_iterator child_iter = children.begin(); child_iter != children.end() ; child_iter++)
		{
		  AddParentInTree(*child_iter, GEDCOMParser::IndividualRecord::MALE, tmp_children);
		  AddParentInTree(*child_iter, GEDCOMParser::IndividualRecord::FEMALE, tmp_children);
		}
	      children = (*tmp_children);
	      delete tmp_children; tmp_children = 0;
	    } 
	}
    }
  SelectCurrent();
  _mmi_browser.show();
  return;
}

