/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYGATEWAY_VIEWINDIVIDUALBROWSER_HH_
#define _BAKERYGATEWAY_VIEWINDIVIDUALBROWSER_HH_

#include "BakeryExtras/View_Linked.hh"
#include "BakeryExtras/View_Navigator.hh"
#include "BakeryGateway/Document.hh"

namespace BakeryGateway {
  template < class MMI >
  class ViewIndividualBrowser : public BakeryExtras::View_Linked < BakeryGateway::Document, GEDCOMParser::IndividualRecord >,
				public BakeryExtras::View_Navigator < BakeryGateway::Document, std::string >
  {
  public:
    virtual void Load(void) = 0;
    ViewIndividualBrowser(void) : 
      _cb_pending(false)
    {
    };

    void SelectCurrent(void) 
    {
      if (_parent_entity != 0)
	{
	  _mmi_browser.Select(_parent_entity->getId());
	}
      return;
    };
    
    void SelectionChanged(void) 
    {
      if (_cb_pending == false)
	{
	  _cb_pending = true;
	  std::string const key = _mmi_browser.getSelectedId();
	  Navigate(key);
	  _cb_pending = false;
	}
      return;
    };
    
    virtual void load_from_document(void) 
    {
      if (_cb_pending == false)
	{
	  _cb_pending = true;
	  Load();
	  _cb_pending = false;
	}
      return;
    };
    
    MMI & getMMI(void) 
    {
      return _mmi_browser;
    };
    
  protected:
    MMI _mmi_browser;
    bool _cb_pending;
  };
};

#endif
