/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYGATEWAY_VIEWFAMILYRECORDS_HH_
#define _BAKERYGATEWAY_VIEWFAMILYRECORDS_HH_

#include "config.h"
#include "BakeryExtras/View.hh"
#include "BakeryExtras/View_Linked.hh"
#include "BakeryExtras/View_RunTimeSubscriber.hh"
#include "BakeryGateway/ViewFamilyRecord.hh"
#include "BakeryGateway/ViewIndividualRecord.hh"
#include "MMIFamilyRecord.hh"
#include "BakeryGateway/Document.hh"
#include "MMIFamilyRecords.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/ChildToFamilyLink.hh"
#include "GEDCOMParser/SpouseToFamilyLink.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"

#include <sigc++/object.h>


namespace BakeryGateway {
  template< class T_FamilyLink >
  class ViewFamilyRecords : public BakeryExtras::View_Linked < BakeryGateway::Document, GEDCOMParser::IndividualRecord >,
			    public BakeryExtras::View_RunTimeSubscriber < BakeryGateway::Document, T_FamilyLink, MMIFamilyRecord >,
			    public SigC::Object
  {
  public:
    ViewFamilyRecords(MMIFamilyRecords * mmi) :
      _mmi_family_records(mmi),
      _parent_view_individual_record(0)
    {
      _mmi_family_records->record_added().connect(SigC::slot(this, &ViewFamilyRecords < T_FamilyLink > ::on_family_added));
      _mmi_family_records->record_deleted().connect(SigC::slot(this, &ViewFamilyRecords < T_FamilyLink > ::on_family_deleted));
    }

    virtual void load_from_document(void)
    {
      if (SubscribeesAreLoadable())
	{
	  if (_parent_entity != 0)
	    {
	      delete_subscribed_views();
	      _mmi_family_records->Clear();
	      std::vector < SmartPtr < T_FamilyLink > > const &family_links = getFamilyLinks(); 
	      for (std::vector < SmartPtr < T_FamilyLink > >::const_iterator iter = family_links.begin(); iter != family_links.end(); iter++)
		{
		  MMIFamilyRecord * mmi_family_record = _mmi_family_records->AddRecord();
		  BakeryExtras::View<BakeryGateway::Document> * family_record_view = _view_factory->createView(mmi_family_record);
		  subscribe_view(family_record_view);
		  BakeryGateway::ViewFamilyRecord * tmp = dynamic_cast < BakeryGateway::ViewFamilyRecord * > (family_record_view);
		  tmp->setStaticIndividualId(_parent_entity->getId());
		  tmp->setDefaultTargetView(_parent_view_individual_record);
		  tmp->set_parent_entity((*iter).getPtr());
		}
	      _mmi_family_records->show_all();
	    }
	}
      return;
    }

    void setParentViewIndividualRecord(BakeryGateway::ViewIndividualRecord * view_individual_record)
    {
      _parent_view_individual_record = view_individual_record;
    }
  private:
    typedef std::vector < SmartPtr < T_FamilyLink > > FamilyLinks_t;
    MMIFamilyRecords * _mmi_family_records;
    BakeryGateway::ViewIndividualRecord * _parent_view_individual_record;
    virtual FamilyLinks_t const &getFamilyLinks(void) = 0;
    int on_family_added(void)
    {
      GEDCOMHelper::IndividualRecordHelper individual_helper(_parent_entity, get_document());
      GEDCOMParser::FamilyRecord * family_record = addFamilyRecord(individual_helper);
      get_document()->set_modified(true);
      _mmi_family_records->ActivateLastPage();
      return 1;
    }
    int on_family_deleted(int family_index)
    {
      _is_loadable = true;
      FamilyLinks_t const &family_links = getFamilyLinks(); 
      T_FamilyLink * deleted_family_link = family_links[family_index].getPtr();
      std::string deleted_family_id = deleted_family_link->getFamXref();
      GEDCOMParser::FamilyRecords_t families = get_document()->getFamilyRecords();
      GEDCOMParser::FamilyRecords_t::const_iterator deleted_family_iter = families.find(deleted_family_id);
      if (deleted_family_iter != families.end())
	{
	  GEDCOMParser::FamilyRecord * deleted_family = (*deleted_family_iter).second.getPtr();
	  GEDCOMHelper::IndividualRecordHelper individual_helper(_parent_entity, get_document());
	  removeFamilyRecord(individual_helper, deleted_family);
	}
      get_document()->set_modified(true);
      return 1;
    };

    virtual GEDCOMParser::FamilyRecord * addFamilyRecord(GEDCOMHelper::IndividualRecordHelper &individual_helper) = 0;
    virtual void removeFamilyRecord(GEDCOMHelper::IndividualRecordHelper &individual_helper, GEDCOMParser::FamilyRecord * const deleted_family) = 0;
  };
  class ViewParentFamilyRecords : public ViewFamilyRecords < GEDCOMParser::ChildToFamilyLink > 
  {
  public:
    ViewParentFamilyRecords(MMIFamilyRecords * mmi) :
      ViewFamilyRecords  < GEDCOMParser::ChildToFamilyLink > (mmi)
    {};
    virtual std::vector < SmartPtr < GEDCOMParser::ChildToFamilyLink > > const &getFamilyLinks(void)
    {
      return _parent_entity->getChildToFamilyLinks();
    };
    virtual GEDCOMParser::FamilyRecord * addFamilyRecord(GEDCOMHelper::IndividualRecordHelper &individual_helper)
    {
      _is_loadable = true;
      return individual_helper.setChildInFamily();
    };
    virtual void removeFamilyRecord(GEDCOMHelper::IndividualRecordHelper &individual_helper, GEDCOMParser::FamilyRecord * const deleted_family)
    {
      individual_helper.RemoveChildFromFamily(deleted_family);
    };
  };

  class ViewUnionFamilyRecords : public ViewFamilyRecords < GEDCOMParser::SpouseToFamilyLink > 
  {
  public:
    ViewUnionFamilyRecords(MMIFamilyRecords * mmi) :
      ViewFamilyRecords < GEDCOMParser::SpouseToFamilyLink >(mmi)
    {};
    virtual std::vector < SmartPtr < GEDCOMParser::SpouseToFamilyLink > > const& getFamilyLinks(void)
      {
	return _parent_entity->getSpouseToFamilyLinks();	
      };
    virtual GEDCOMParser::FamilyRecord * addFamilyRecord(GEDCOMHelper::IndividualRecordHelper &individual_helper)
    {
      _is_loadable = true;
      return individual_helper.setSpouseInFamily();
    };
    virtual void removeFamilyRecord(GEDCOMHelper::IndividualRecordHelper &individual_helper, GEDCOMParser::FamilyRecord * const deleted_family)
    {
      individual_helper.RemoveSpouseFromFamily(deleted_family);
    };
  };

};

#endif
