/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERY_GATEWAY_VIEWFAMILYRECORD_HH_
#define _BAKERY_GATEWAY_VIEWFAMILYRECORD_HH_

#include "config.h"
#include "bakery/bakery.h"
#include "BakeryGateway/ViewIndividualRecord.hh"
#include "BakeryExtras/View_Linked.hh"
#include "BakeryExtras/View_Navigator.hh"
#include "BakeryExtras/View_RunTimeSubscriber.hh"
#include "BakeryGateway/Document.hh"
#include "GEDCOMParser/FamilyRecord.hh"
#include "MMIFamilyRecord.hh"
#include "../../widgets/WidgetIndividualFactory.hh"
#include <sigc++/object.h>
#include "PredicateMenuItemsFactory.hh"

namespace BakeryGateway {
  class ViewFamilyRecord : public BakeryExtras::View_Linked < BakeryGateway::Document, GEDCOMParser::FamilyLink >,
			   public BakeryExtras::View_Navigator < BakeryGateway::Document, std::string >,
			   public BakeryExtras::View_RunTimeSubscriber < BakeryGateway::Document, GEDCOMParser::FamilyRecord, MMIEvent >
  //			   public  SigC::Object
  {
  public:
    ViewFamilyRecord(MMIFamilyRecord * mmi);
    ~ViewFamilyRecord(void);
    virtual void load_from_document();
    void setStaticIndividualId(std::string const &individual_id);
    void setDefaultTargetView(BakeryGateway::ViewIndividualRecord * target_view);
  private:
    MMIFamilyRecord * _mmi;
    std::string _static_individual_id;
    BakeryGateway::ViewIndividualRecord * _default_target_view;
    WidgetIndividualFactory * _dynamic_widget_individual_factory;
    WidgetIndividualFactory * _static_widget_individual_factory;
    WidgetIndividualFactory * get_factory_widget(std::string const &individual_id);
    void manage_individual(GEDCOMParser::IndividualRecords_t const &individuals, std::string const &individual_id, WidgetIndividual * widget);
    std::string get_name_individual(GEDCOMParser::IndividualRecords_t const &individuals, std::string const &individual_id) const;
    WidgetIndividual::NavigationReturnHandler_t manage_navigation(std::string target_id, bool new_win);
    PredicateMenuItemsFactory::IndividualRecordPredicates_t * _father_predicates;
    PredicateMenuItemsFactory::IndividualRecordPredicates_t * _mother_predicates;
    PredicateMenuItemsFactory::IndividualRecordPredicates_t * _child_predicates;
    PredicateMenuItemsFactory::IndividualRecordPredicates_t * const get_father_predicates(GEDCOMParser::IndividualRecord const * const);
    PredicateMenuItemsFactory::IndividualRecordPredicates_t * const get_mother_predicates(void);
    PredicateMenuItemsFactory::IndividualRecordPredicates_t * const get_child_predicates(GEDCOMParser::IndividualRecord const * const);
    void manage_menu_items(GEDCOMParser::IndividualRecords_t const &individuals, WidgetIndividual * const widget, PredicateMenuItemsFactory::IndividualRecordPredicates_t * const predicates);
    WidgetIndividual::ChangeReturnHandler_t husband_changed(std::string new_id);
    WidgetIndividual::ChangeReturnHandler_t wife_changed(std::string new_id);
    WidgetIndividual::ChangeReturnHandler_t spouse_changed(std::string const &new_id);
    WidgetIndividual::ChangeReturnHandler_t child_changed(std::string new_id);
    WidgetIndividual::NewReturnHandler_t husband_newed(void);
    WidgetIndividual::NewReturnHandler_t wife_newed(void);
    WidgetIndividual::NewReturnHandler_t child_newed(void);
    WidgetIndividual::NewReturnHandler_t spouse_newed(std::string const &sex);
    WidgetIndividual::UnlinkReturnHandler_t husband_unlinked(void);
    WidgetIndividual::UnlinkReturnHandler_t wife_unlinked(void);
    WidgetIndividual::UnlinkReturnHandler_t child_unlinked(int child_index);
    WidgetIndividual::UnlinkReturnHandler_t spouse_unlinked(std::string const &spouse_id, GEDCOMParser::FamilyRecord * const family_record);
    GEDCOMParser::FamilyRecord * const get_parent_family_record(void) const;
  };
};


#endif

