/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "PredicateMenuItemsFactory.hh"
#include "GEDCOMParser/Predicates/GenericPredicateIndividualRecords.hh"
#include "GEDCOMParser/Predicates/PredicateIndividualRecordsAdapter.hh"
#include <functional>

PredicateMenuItemsFactory::PredicateMenuItemsFactory(void) : 
  MenuItemsFactory(),
  _predicates(0),
  _individual_records(0)
{
  return;
}

MenuItems_t * PredicateMenuItemsFactory::getMenuItems(void) const
{
  MenuItems_t * res = 0;
  OneMenuItems_t * tmp = 0;
  std::string menu_id;
  std::string menu_label;
  if (_predicates != 0)
    {
      res = new MenuItems_t;
      setBaseMenuItems(res);
      tmp = new OneMenuItems_t;
      for (PredicateMenuItemsFactory::IndividualRecordPredicates_t::const_iterator 
	     predicate_iter = _predicates->begin();
	   predicate_iter != _predicates->end();
	   predicate_iter++)
	{
	  if (!(*predicate_iter).Null())
	    {
	      GEDCOMParser::Predicates::PredicateIndividualRecordsAdapter adapter((*predicate_iter).getPtr());	  
	      GEDCOMParser::IndividualRecords_t::const_iterator individu_iter = find_if(_individual_records->begin(), _individual_records->end(), adapter);
	      do 
		{
		  if (individu_iter != _individual_records->end())
		    {
		      menu_id = (*individu_iter).second->getId();
		      menu_label = (*individu_iter).second->getPersonalNames()[0]->getName();
		      tmp->push_back(new MenuItem(menu_label, menu_label, menu_id, MenuItem::e_Change));
		      individu_iter = find_if(++individu_iter, _individual_records->end(), adapter);
		    }
		}
	      while (individu_iter != _individual_records->end());
	    }
	  if (tmp->size() > 0)
	    {
	      res->push_back(*tmp);
	      delete tmp; tmp = 0; tmp = new OneMenuItems_t;
	    }
	}
    }
  return res;
}

void PredicateMenuItemsFactory::setPredicates(IndividualRecordPredicates_t * const predicates)
{
  _predicates = predicates;
  return;
}

void PredicateMenuItemsFactory::setIndividualRecords(GEDCOMParser::IndividualRecords_t const &individus)
{
  _individual_records = &individus;
  return;
}
