/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "BakeryGateway/App.hh"

BakeryGateway::App::App(void) : 
  Bakery::App_WithDoc("",""), 
  _view()
{ 
  return;
}

Bakery::App * BakeryGateway::App::new_instance(void)
{
  App * app = Gtk::manage(new App());
  return app;
}

void BakeryGateway::App::init(void)
{  
  type_vecStrings vecAuthors;
  vecAuthors.push_back("Cyril PICARD <cpcp@free.fr>");
  std::string version(VERSION);
  std::string label(PACKAGE_NAME);
  
  label = label + " " + version;
  set_about_information(label, vecAuthors, _("Copyright (c) 2002 by Cyril PICARD\nReleased under the GNU General Public License"), _("Copyright (c) 2002 by Cyril PICARD\nReleased under the GNU General Public License\nA GEDCOM files viewer\n\nhttp://www.freesoftware.fsf.org/ghosts\nghosts-users@mail.freesoftware.fsf.org"));
  set_contents(_view);
  Bakery::App_WithDoc::init();
  return;
}

void BakeryGateway::App::init_menus(void)
{
  init_menus_file();
  init_menus_edit();

  type_vecGnome_UI_Info menu_browse;
  menu_browse.push_back(Gnome::UI::Item(_("List"), slot(&_view, &BakeryGateway::View::on_menu_ListBrowser), _("List browser")));
  
  menu_browse.push_back(Gnome::UI::Item(_("Ascendant tree (current individu)"), slot(&_view, &BakeryGateway::View::on_menu_TreeBrowser), _("Tree browser")));

  m_menu_UI_Infos.push_back(Gnome::UI::Menu(_("_Browse"), menu_browse) );


  type_vecGnome_UI_Info menu_data;
  menu_data.push_back(Gnome::UI::Item(_("Transmission header"), slot(&_view, &BakeryGateway::View::on_menu_DataHeader), _("Transmission header")));
  
  m_menu_UI_Infos.push_back(Gnome::UI::Menu(_("_Data"), menu_data) );

  init_menus_help();
  create_menus(m_menu_UI_Infos);
  install_menu_hints();
  return;
}

void BakeryGateway::App::init_create_document(void)
{
  BakeryGateway::Document * doc = 0;
  if (m_pDocument == NULL)
    {
      m_pDocument = new BakeryGateway::Document();
      doc = static_cast<BakeryGateway::Document *>(m_pDocument);
      doc->init();
      doc->set_modified(false);
      doc->set_is_new(true);
      doc->set_view(&_view);
      _view.set_document(doc);
      _view.getViewIndividualRecord()->InitCurrentIndividu();
      _view.load_from_document();
    }
  Bakery::App_WithDoc::init_create_document();
  return;
}

void BakeryGateway::App::on_Document_load(void)
{
  // nothing to do, since the load is managed in the Document class
}
void BakeryGateway::App::on_Document_modified(void)
{
  _view.load_from_document();
  Bakery::App_WithDoc::on_Document_modified();
  return;
}
