/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYEXTRAS_VIEWSUBSCRIBER_HH_
#define _BAKERYEXTRAS_VIEWSUBSCRIBER_HH_

#include "bakery/bakery.h"
#include "BakeryExtras/View_BaseSubscriber.hh"
#include "BakeryExtras/View_Linked.hh"

namespace BakeryExtras {
  template< class T_Document, class T_Entity >
  class View_Subscriber : virtual public BakeryExtras::View_BaseSubscriber<T_Document>
  {
  public:
    View_Subscriber() : _entity(0)
    {
    }
    virtual ~View_Subscriber()
    {
    }
    typedef View<T_Document> type_view;
    typedef std::vector<type_view*> type_vecViews;
    virtual void subscribe_view(type_view* pView)
    {
      if(pView)
	{
	  pView->set_document(get_document());
	  m_vecViews.push_back(pView);
	}
    };
    virtual void unsubscribe_view(type_view* pView)
    {
      type_vecViews::iterator iter = std::find(m_vecViews.begin(), m_vecViews.end(), pView);
      if(iter != m_vecViews.end())
	m_vecViews.erase(iter);
    };

    virtual void delete_subscribed_views(void)
    {
      for (int cpt = 0; cpt < m_vecViews.size(); cpt++)
	{
	  delete m_vecViews[cpt];
	}
      m_vecViews.clear();
    };

    virtual void set_document(T_Document* pDocument)
    {
      //Call base class:
      BakeryExtras::View<T_Document>::set_document(pDocument);
      
    //Change the document in the child views.
      for(type_vecViews::iterator iter = m_vecViews.begin(); iter != m_vecViews.end(); iter++)
	{
	  type_view* pView = *iter;
	  if(pView)
	    pView->set_document(pDocument);
	}
    };
    virtual bool SubscribeesAreLoadable(void) const
    {
      bool res;
      res = true;
      type_vecViews::const_iterator iter = m_vecViews.begin();
      View_BaseSubscriber < T_Document > * tmp_subscriber = 0;
      while ((iter != m_vecViews.end()) && (res == true))
	{
	  res = (*iter)->IsLoadable();
	  if (res == true)
	    {
	      tmp_subscriber = dynamic_cast < View_BaseSubscriber <T_Document> * >(*iter);
	      if (tmp_subscriber != 0)
		{
		  res = tmp_subscriber->SubscribeesAreLoadable();
		}
	    }
	  iter++;
	}
      return res;
    };
    virtual void notify_subscribees() 
    {
      //Notify the dependent views:
      BakeryExtras::View_Linked< T_Document, T_Entity> * tmp = 0;
      for(type_vecViews::iterator iter = m_vecViews.begin(); iter != m_vecViews.end(); iter++)
	{
	  type_view* pView = *iter;
	  if(pView)
	    {
	      tmp = dynamic_cast< BakeryExtras::View_Linked < T_Document, T_Entity > * >(pView);
	      if (tmp != 0)
		{
		  tmp->set_parent_entity(_entity);
		}
	    }
	}
    }
    virtual void set_entity(T_Entity * entity) { _entity = entity; }
  protected:
    T_Entity * _entity;  
    type_vecViews m_vecViews;

  };
};

#endif
