/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYEXTRAS_VIEW_RUNTIMESUBSCRIBER_HH_
#define _BAKERYEXTRAS_VIEW_RUNTIMESUBSCRIBER_HH_

#include "BakeryExtras/View_Subscriber.hh"
#include "BakeryExtras/View_Factory.hh"

namespace BakeryExtras {
  template< class T_Document, class T_Entity, class T_MMI >
  class View_RunTimeSubscriber : virtual public BakeryExtras::View_Subscriber < T_Document, T_Entity >
  {
  public:
    View_RunTimeSubscriber(void) : 
      BakeryExtras::View_Subscriber< T_Document, T_Entity >(),
      _view_factory(0) {
    };
    void setFactory(BakeryExtras::View_Factory< T_Document, T_MMI > * const factory) 
    {
      _view_factory = factory;
      return;
    };
    ~View_RunTimeSubscriber(void)
    {
      delete _view_factory; _view_factory = 0;
    }
  protected:
    BakeryExtras::View_Factory< T_Document, T_MMI> * _view_factory;
  };
};

#endif 
