/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#ifndef _WIDGET_PLACE_HH_
#define _WIDGET_PLACE_HH_

#include <gtk--/optionmenu.h>
#include <sigc++/slot.h>
#include <string>
#include "EditableMenuItem.hh"

class WidgetPlace : public Gtk::OptionMenu
{
public:
  WidgetPlace(void);
  void setValue(std::string const &value);
  void Clear(void);
  typedef int ChangeReturnHandler_t;
  typedef SigC::Signal1 < ChangeReturnHandler_t, std::string > ChangeSignalHandler_t;
  ChangeSignalHandler_t &changed(void);
  std::string const &getValue(void) const;
private:
  EditableMenuItem::ChangeReturnHandler_t editable_menuitem_changed(void);
  void erase_noneditable_menuitems(void);
  void insert_noneditable_menuitems(void);
  EditableMenuItem * _editable_menuitem;
  ChangeSignalHandler_t _changed_signal;
  bool _internal_change;
};

#endif
