/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "WidgetPlace.hh"
#include <gtk--/menu.h>
#include <gtk--/menushell.h> 
#include <iostream>

#define VALUES_SEPARATOR ","
#define DEFAULT_MENU_HISTORY 0


WidgetPlace::WidgetPlace(void) :
  _editable_menuitem(0),
  _changed_signal(),
  _internal_change(false)
{
  Gtk::Menu * m = manage(new Gtk::Menu());
  _editable_menuitem = manage(new EditableMenuItem());
  _editable_menuitem->changed().connect(slot(this, &WidgetPlace::editable_menuitem_changed));
  m->append(*_editable_menuitem);
  set_menu(*m);
  return;
}

void WidgetPlace::setValue(std::string const &value)
{
  set_usize(-1, 25);
  set_flags(GTK_CAN_FOCUS);
  
  Gtk::Menu * m = get_menu();
  _internal_change = true;
  _editable_menuitem->set_text(value);
  _internal_change = false;
  erase_noneditable_menuitems();
  insert_noneditable_menuitems();
  set_history(DEFAULT_MENU_HISTORY);
  show_all();
  return;
}

void WidgetPlace::erase_noneditable_menuitems(void)
{
  Gtk::Menu * m = get_menu();
  if (m != 0)
    {
      if (m->items().size() > 1)
	{
	  m->items().erase(m->items().begin(), --m->items().end());
	}
    }
  show_all();
  return;
}

void WidgetPlace::insert_noneditable_menuitems(void)
{
  std::string const values = _editable_menuitem->get_text();
  int start_value = 0;
  int end_value = 0;
  std::string value;
  Gtk::MenuItem * mi = 0;
  Gtk::Menu * m = get_menu();
  Gtk::Menu_Helpers::MenuList::const_iterator iter_editable = m->items().end();  if (m->items().size() > 0) 
    {
      iter_editable--;
    }
  
  while (end_value != -1)
    {
      end_value = values.find(VALUES_SEPARATOR, start_value);
      if (end_value != -1)
	{
	  value.assign(values, start_value, end_value - start_value);
	}
      else
	{
	  value.assign(values, start_value, values.length() - start_value);
	}
      if (value != "")
	{
	  mi = manage(new Gtk::MenuItem(value));
	  m->items().insert(iter_editable,*mi);
	}
      start_value = end_value + 1;
    }
  show_all();
}

EditableMenuItem::ChangeReturnHandler_t WidgetPlace::editable_menuitem_changed(void)
{
  if (_internal_change == false)
    {
      erase_noneditable_menuitems();
      insert_noneditable_menuitems();
      std::string new_values = _editable_menuitem->get_text();
      _changed_signal.emit(new_values);
    }
  return 0;
}

void WidgetPlace::Clear(void)
{
  _internal_change = true;
  erase_noneditable_menuitems();
  _editable_menuitem->set_text("");
  _internal_change = false;
  return;
}

WidgetPlace::ChangeSignalHandler_t &WidgetPlace::changed(void)
{
  return _changed_signal;
}
