/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include <WidgetNote.hh>

#include <gtk--/menu.h>
#include <gtk--/menushell.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/style.h>


#define NOTECOLOR "lightyellow"

#define NOTEPIXMAP PIXMAP_PATH "/ghosts-note.xpm"

WidgetNote::TextNoteMenuItem::TextNoteMenuItem(void) :  
  Gtk::MenuItem(),
  _text(0)
{
  
  _text = manage(new Gtk::Text());
  Gtk::Style * note_style = _text->get_style()->copy();
  note_style->set_base(GTK_STATE_NORMAL,Gdk_Color(NOTECOLOR));
  note_style->set_base(GTK_STATE_ACTIVE,Gdk_Color(NOTECOLOR));
  note_style->set_base(GTK_STATE_PRELIGHT,Gdk_Color(NOTECOLOR));
  note_style->set_base(GTK_STATE_SELECTED,Gdk_Color(NOTECOLOR));
  note_style->set_base(GTK_STATE_INSENSITIVE,Gdk_Color(NOTECOLOR));     
  _text->set_style(*note_style);
  Gtk::ScrolledWindow *scroller = manage(new class Gtk::ScrolledWindow());
  scroller->set_policy(GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  scroller->set_usize(200,200);
  scroller->add(*_text);
  add(*scroller);
  return;
}

void WidgetNote::TextNoteMenuItem::set_text(std::string const &value)
{
  if (_text != 0)
    {
      clear();
      _text->insert(value);
    }
  return;
}

void WidgetNote::TextNoteMenuItem::clear(void)
{
  if (_text->get_length() > 0)
    {
      _text->delete_text(0,-1);  
    }
  return;
}

WidgetNote::PixmapNoteMenuItem::PixmapNoteMenuItem(void) : 
  Gtk::MenuItem(),
  _pixmap(0)
{
  return;
}

void WidgetNote::PixmapNoteMenuItem::set_text(void)
{
  if (_pixmap == 0)
    {
      _pixmap = new Gtk::Pixmap();
      _pixmap->set(NOTEPIXMAP);
      add(*_pixmap);
      //      show_all();
    }
  return;
}

void WidgetNote::PixmapNoteMenuItem::clear(void)
{
  delete _pixmap; _pixmap = 0;
  return;
}

WidgetNote::WidgetNote(void) : 
  Gtk::MenuBar(),
  _submenu(0),
  _texts(),
  _pixmap(0)
{
  return;
}

void WidgetNote::add_text(std::string const & value)
{
  if (value != "")
    {
      if (_submenu == 0)
	{
	  _submenu = new class Gtk::Menu();
	  _pixmap = new PixmapNoteMenuItem();
	  _pixmap->set_text();
	  _submenu = new class Gtk::Menu();
	  _submenu->items().push_back(Gtk::Menu_Helpers::TearoffMenuElem());
	  _pixmap->set_submenu(*_submenu);
	  items().push_back(Gtk::Menu_Helpers::MenuElem(*_pixmap));
	}
      TextNoteMenuItem * text = new TextNoteMenuItem();
      text->set_text(value);
      _texts.push_back(SmartPtr < TextNoteMenuItem >(text));
      _submenu->items().push_back(Gtk::Menu_Helpers::MenuElem(*text));
    }
  //  show_all();
  return;
}

void WidgetNote::clear(void)
{
  delete _submenu; _submenu = 0;
  _texts.clear(); 
  delete _pixmap; _pixmap = 0;
  
  return;
}


WidgetNote::~WidgetNote(void)
{
  delete _submenu; _submenu = 0;
  delete _pixmap; _pixmap = 0;
  return;
}
