/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "ButtonIndividual.hh"
#include <gtk--/menuitem.h>
#include <gtk--/label.h>
#include <iostream>
#include "UnlinkMenuItemsFactory.hh"

#define BUTTON_LEFT 1
#define BUTTON_RIGHT 3
#define MENU_MAX_ELEMS 6

ButtonIndividual::ButtonIndividual(void) : 
  _button(),
  WidgetIndividual()
{
  Gtk::Label * label = new Gtk::Label();
  label->set_alignment(0.5, 0.5);
  _button.add(*label);
  _button.button_release_event.connect(slot(this, &ButtonIndividual::navigation_asked_emit));
  _button.button_release_event.connect(slot(this, &ButtonIndividual::popdown_menu));
  add(_button);
  MenuItemsFactory * factory = new UnlinkMenuItemsFactory();
  setUnlinkMenuItemsFactory(factory);
  return;
}

void ButtonIndividual::setValue(std::string const &label, std::string const &id)
{
  Gtk::Label * widget = 0;
  widget = static_cast<Gtk::Label *>(_button.get_child());
  if (widget != 0)
    {
      widget->set_text(label);
    }
  WidgetIndividual::setValue(label, id);
  return;
}

ButtonIndividual::NavigationReturnHandler_t ButtonIndividual::navigation_asked_emit(GdkEventButton * event)
{
  if (event->button == BUTTON_LEFT)
    {
      bool ctrl_selected = (event->state & GDK_CONTROL_MASK);
      _navigation_asked_signal.emit(_id, ctrl_selected);
    }
  return 1;
}

ButtonIndividual::NavigationReturnHandler_t ButtonIndividual::popdown_menu(GdkEventButton * event)
{
  if (event->button == BUTTON_RIGHT)
    {
      MenuItemsFactory const * factory = 0;
      if (_id != "")
	{
	  factory = _unlink_menu_items_factory;
	}
      else
	{
	  factory = _link_menu_items_factory;
	}
      if (factory != 0)
	{
	  MenuItems_t * menu_items = factory->getMenuItems();
	  Gtk::Menu * menu = new Gtk::Menu();
	  Gtk::Menu * submenu = 0; 
	  for (MenuItems_t::const_iterator submenu_iter = menu_items->begin();
	       submenu_iter != menu_items->end(); submenu_iter++)
	    {
	      if (submenu == 0)
		{
		  submenu = menu;
		}
	      else
		{
		  submenu = InitSubMenu(submenu, "More");
		}
	      
	      int cpt_menu;
	      cpt_menu = 0;
	      for (OneMenuItems_t::const_iterator menu_iter = submenu_iter->begin();
		   menu_iter != submenu_iter->end(); menu_iter++)
		{
		  std::string menu_label = (*menu_iter)->getLabel();
		  std::string menu_value = (*menu_iter)->getValue();
		  std::string menu_id = (*menu_iter)->getId();
		  MenuItem::enumMenuItemType menu_type = (*menu_iter)->getType();
		  Gtk::MenuItem * menu_item = manage(new Gtk::MenuItem(menu_label));
		  menu_item->activate.connect(bind(bind(slot(this, &ButtonIndividual::changed_emit), menu_type), menu_value, menu_id));
		  submenu->append(*menu_item);
		  cpt_menu++;
		  if (cpt_menu == MENU_MAX_ELEMS)
		    {
		      submenu = InitSubMenu(submenu, "List continue...");
		      cpt_menu = 0;
		    }
		}
	    }
	  menu->show_all();
	  guint button = 1;
	  guint32 activate_time = 0;
	  menu->popup(button, activate_time);
	}
    }
  return 1;
}

Gtk::Menu * ButtonIndividual::InitSubMenu(Gtk::Menu * parent_menu, std::string const &label)
{
  Gtk::Menu * res = 0;
  Gtk::MenuItem * menu_item = manage(new Gtk::MenuItem(label));
  parent_menu->append(*menu_item);
  res = manage(new Gtk::Menu());
  menu_item->set_submenu(*res);
  return res;
}

void ButtonIndividual::changed_emit(std::string new_value, std::string new_id, MenuItem::enumMenuItemType menu_type)
{
  if (menu_type == MenuItem::e_New)
    {
      setValue(new_value, new_id);
      _newed_signal.emit();
    }
  else if (menu_type == MenuItem::e_Unlink)
    {
      setValue(new_value, new_id);
      _unlinked_signal.emit();
    }
  else
    {
      if (new_id != _id)
	{
	  setValue(new_value, new_id);
	  _changed_signal.emit(new_id);
	}
    }
}
