/** 
    Copyright 2003 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "BakeryGateway/WindowIndividualRecordTarget.hh"
#include "BakeryExtras/View_Composite.hh"

BakeryGateway::WindowIndividualRecordTarget::WindowIndividualRecordTarget(BakeryGateway::View * const target_view) : 
  _target_view(target_view)
{
  if (_target_view != 0)
    {
      add(*_target_view);
    }
  return;
}

int BakeryGateway::WindowIndividualRecordTarget::delete_target_view(GdkEventAny * event)
{
  BakeryExtras::View_Composite < BakeryGateway::Document > * main_view = 
    dynamic_cast<BakeryExtras::View_Composite < BakeryGateway::Document > *>(_target_view->get_document()->get_view());
  if (main_view != 0)
    {
      main_view->remove_view(_target_view);
    }
  delete _target_view; _target_view = 0;
  return 0;  
}

BakeryGateway::WindowIndividualRecordTarget::~WindowIndividualRecordTarget(void)
{
  if (_target_view != 0)
    {
      delete_target_view(0);
    }
  return;
}
