/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/ViewPersonalName.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"

BakeryGateway::ViewPersonalName::ViewPersonalName(MMIPersonalName * mmi) : 
  _mmi_personal_name(mmi),
  _during_load(false)
{
  _mmi_personal_name->getNamePieceGivenWidget()->changed.connect(SigC::slot(this, &ViewPersonalName::save_to_document));
  _mmi_personal_name->getNamePieceSurnameWidget()->changed.connect(SigC::slot(this, &ViewPersonalName::save_to_document));
  return;
}

void BakeryGateway::ViewPersonalName::save_to_document(void)
{
  _is_loadable = false;
  if ((!_during_load) && (_parent_entity != 0))
    {
      std::string const new_given = _mmi_personal_name->getNamePieceGiven();
      std::string const new_surname = _mmi_personal_name->getNamePieceSurname();
      GEDCOMHelper::IndividualRecordHelper helper(_parent_entity, get_document());
      helper.setPersonalName(new_given, new_surname);
      _mmi_personal_name->setPersonalName(_parent_entity->getPersonalNames()[0]->getName());
      get_document()->set_modified(true);
    }
  _is_loadable = true;
  return;
}

BakeryGateway::ViewPersonalName::~ViewPersonalName(void)
{
  return;
}

void BakeryGateway::ViewPersonalName::load_from_document(void)
{
  if (IsLoadable())
    {
      _during_load = true;
      if (_parent_entity != 0)
	{
	  if (_parent_entity->getPersonalNames().size() > 0)
	    {
	      _entity = _parent_entity->getPersonalNames()[0].getPtr();
	      
	      _mmi_personal_name->setPersonalName(_parent_entity->getPersonalNames()[0]->getName());
	      _mmi_personal_name->setNamePieceGiven(_parent_entity->getPersonalNames()[0]->getGivn());
	      _mmi_personal_name->setNamePieceSurname(_parent_entity->getPersonalNames()[0]->getSurn());
	    }
	  else
	    {
	      _mmi_personal_name->setPersonalName("");
	      _mmi_personal_name->setNamePieceGiven("");
	      _mmi_personal_name->setNamePieceSurname("");
	    }
	}
    }
  notify_subscribees();
  _during_load = false;
  return;
}
