/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/ViewListBrowser.hh"

BakeryGateway::ViewListBrowser::ViewListBrowser(void)
{
  _mmi_browser.getList()->select_row.connect(slot(this, &ViewListBrowser::cb_select_row));
  return;
}

void BakeryGateway::ViewListBrowser::cb_select_row(gint p0, gint p1, GdkEvent* p2)
{
  ViewListBrowser::SelectionChanged();
  return;
}

void BakeryGateway::ViewListBrowser::Load(void)
{
  _mmi_browser.clear();
  GEDCOMParser::IndividualRecords_t individuals = get_document()->getIndividualRecords();
  if (individuals.size() > 0)
    {
      for (GEDCOMParser::IndividualRecords_t::const_iterator iter = individuals.begin(); iter != individuals.end(); iter++)
	{
	  _mmi_browser.addIndividual(getIndividualRow(iter->second), iter->second->getId());
	}
    }
  SelectCurrent();
  return;
}

std::vector<std::string> const BakeryGateway::ViewListBrowser::getIndividualRow(SmartPtr<GEDCOMParser::IndividualRecord> const & individual)
{
  std::vector<std::string> individual_row;
  std::string lastname;
  std::string personalname;
  std::string birth_date;
  std::string birth_place;
  std::string death_date;
  std::string death_place;

  
  // handling of last name and personal name 
  if (individual->getPersonalNames().size() > 0)
    {
      personalname = individual->getPersonalNames()[0]->getName();
      lastname = individual->getPersonalNames()[0]->getSurn();
    }
  else
    {
      personalname = "";
    }
  
  // handling of birth
  GEDCOMParser::IndividualEvents_t events = individual->getIndividualEvents();
  
  GEDCOMParser::IndividualEvents_t::const_iterator iter = 
    std::find(events.begin(), 
	      events.end(), 
	      GEDCOMParser::IndividualEvent::e_Birt);
  if (iter != events.end())
    {
      if (!(*iter)->getEvent().Null())
	{
	  birth_date = (*iter)->getEvent()->getDate();
	  if (!(*iter)->getEvent()->getPlace().Null())
	    birth_place = (*iter)->getEvent()->getPlace()->getPlaceValue();
	}
    }
  
  // handling of death
  iter = 
    std::find(events.begin(), 
	      events.end(), 
	      GEDCOMParser::IndividualEvent::e_Deat);
  if (iter != events.end())
    {
      if (!(*iter)->getEvent().Null())
	{
	  death_date = (*iter)->getEvent()->getDate();
	  if (!(*iter)->getEvent()->getPlace().Null())
	    death_place = (*iter)->getEvent()->getPlace()->getPlaceValue();
	}
    }
  individual_row.push_back(lastname);
  individual_row.push_back(personalname);
  individual_row.push_back(birth_date);
  individual_row.push_back(birth_place);
  individual_row.push_back(death_date);
  individual_row.push_back(death_place);
  return individual_row;
}

