/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERY_GATEWAY_VIEWLINKEDNOTE_HH_
#define _BAKERY_GATEWAY_VIEWLINKEDNOTE_HH_

#include "config.h"
#include "bakery/bakery.h"
#include "BakeryExtras/View_Linked.hh"
#include "BakeryGateway/Document.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/NoteStructure.hh"

namespace BakeryGateway {
  template < class T_ParentEntity, class MMI > 
  class ViewLinkedNote : public BakeryExtras::View_Linked < BakeryGateway::Document, T_ParentEntity >
  {
  public:
    ViewLinkedNote(MMI * mmi) : _mmi(mmi)
      {
	return;
      };
    ~ViewLinkedNote(void)
      {
	return;
      };
    virtual void load_from_document() {
      if (IsLoadable())
	{
	  _mmi->clear();
	  if (_parent_entity != 0)
	    {
	      GEDCOMParser::AttachmentManager::NoteStructures_t notes = _parent_entity->getNoteStructures();
	      for (GEDCOMParser::AttachmentManager::NoteStructures_t::const_iterator note_iter = notes.begin(); note_iter != notes.end(); note_iter++)
		{
		  _mmi->add_text((*note_iter)->getSubmitterText());
		}
	    }
	}
      return;
    };
  private:
    MMI * _mmi;
  };
};


#endif

