/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERY_GATEWAY_VIEWINDIVIDUALRECORD_HH_
#define _BAKERY_GATEWAY_VIEWINDIVIDUALRECORD_HH_

#include "config.h"
#include "bakery/bakery.h"
#include "BakeryExtras/View_Subscriber.hh"
#include "BakeryExtras/View_Target.hh"
#include "BakeryGateway/Document.hh"
#include "MMIIndividualRecord.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include <sigc++/object.h>

namespace BakeryGateway {
  class ViewIndividualRecord : public BakeryExtras::View_Subscriber< BakeryGateway::Document, GEDCOMParser::IndividualRecord >,
			       public BakeryExtras::View_Target< BakeryGateway::Document, std::string >,
			       public SigC::Object
  {
  public:
    ViewIndividualRecord(MMIIndividualRecord * mmi);
    ~ViewIndividualRecord(void);
    virtual void load_from_document();
    virtual void save_to_document();
    virtual void Goto(std::string const &key);
    void InitCurrentIndividu(void);
  private:
    MMIIndividualRecord * _mmi_individual_record;
    std::string const getIndividualName(SmartPtr<GEDCOMParser::IndividualRecord> const & individual);
    void LoadCurrentIndividu(void);
    void SetCurrentIndividu(GEDCOMParser::IndividualRecord * const individu);
    GEDCOMParser::IndividualRecords_t const &get_individuals(void) const;
    GEDCOMParser::IndividualRecord *  _current_individu;
    bool _during_load;
    bool _during_save;

  };
};

#endif

