/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/ViewIndividualRecord.hh"
#include "options/Options.hh"
#include <gtk--/menu.h>
#include <gtk--/menushell.h> 
#include <algorithm>
#include "GEDCOMParser/Predicates/HasChild.hh"
#include "GEDCOMParser/Predicates/PredicateIndividualRecordsAdapter.hh"
#include "GEDCOMParser/Predicates/GenericPredicateIndividualRecords.hh"
#include "GEDCOMParser/Predicates/PredicateIndividualRecords.hh"


BakeryGateway::ViewIndividualRecord::ViewIndividualRecord(MMIIndividualRecord * mmi) : 
  _mmi_individual_record(mmi),
  _current_individu(0),
  _during_load(false),
  _during_save(false)
{
  
  Gtk::Menu * menu = _mmi_individual_record->getSexWidget()->get_menu();
  Gtk::Menu_Helpers::MenuList items = menu->items();
  for (Gtk::Menu_Helpers::MenuList::iterator iter = items.begin();
       iter != items.end(); iter++)
    {
      (*iter)->activate.connect(SigC::slot(this, &ViewIndividualRecord::save_to_document));
    }
  return;
}

void BakeryGateway::ViewIndividualRecord::save_to_document(void)
{
  if ((!_during_load) && (!_during_save) && (_entity != 0))
    {
      _is_loadable = false;
      _during_save = true;
      enumSex mmi_sex = _mmi_individual_record->getSex();
      std::string new_sex;
      switch (mmi_sex) {
      case e_Man:
	new_sex = GEDCOMParser::IndividualRecord::MALE;
	break;
      case e_Woman:
	new_sex = GEDCOMParser::IndividualRecord::FEMALE;
	break;	
      default:
	new_sex = _entity->getSex();
      }
      if (new_sex != _entity->getSex())
	{
	  _entity->setSex(new_sex);
	}
      get_document()->set_modified(true);
      _during_save = false;
      _is_loadable = true ;
    }
  return;
}


BakeryGateway::ViewIndividualRecord::~ViewIndividualRecord(void)
{
  return;
}

void BakeryGateway::ViewIndividualRecord::InitCurrentIndividu(void)
{
  GEDCOMParser::IndividualRecord * tmp_individu = 0;

  if (get_individuals().size() != 0)
    {
      GEDCOMParser::Predicates::PredicateIndividualRecords * predicate;
      predicate = GEDCOMParser::Predicates::getGenericPredicateIndividualRecords(std::compose1(std::logical_not<bool>(), std::bind1st(GEDCOMParser::Predicates::HasChild(), get_document())));
      GEDCOMParser::Predicates::PredicateIndividualRecordsAdapter adapter(predicate);
      GEDCOMParser::IndividualRecords_t::const_iterator root = std::find_if(get_individuals().begin(), get_individuals().end(), adapter);
      if (root != get_individuals().end())
	{
	  tmp_individu = root->second.getPtr();
	}
      else
	{
	  tmp_individu = get_individuals().begin()->second.getPtr();
	}
      delete predicate; predicate = 0;
    }
  SetCurrentIndividu(tmp_individu);
  return;
}

void BakeryGateway::ViewIndividualRecord::load_from_document(void)
{
  if (IsLoadable())
    {
      _during_load = true;
      if (_current_individu != 0)
	{
	  LoadCurrentIndividu();
	  notify_subscribees();
	}
      _mmi_individual_record->show_all();
      _during_load = false;
    }
  return;
}

std::string const BakeryGateway::ViewIndividualRecord::getIndividualName(SmartPtr<GEDCOMParser::IndividualRecord> const & individual)
{
  std::string individual_name;
  if (individual->getPersonalNames().size() > 0)
    {
      individual_name = individual->getPersonalNames()[0]->getName();
    }
  else
    {
      individual_name = "";
    }
  return individual_name;
}

void BakeryGateway::ViewIndividualRecord::LoadCurrentIndividu(void)
{
  if (_current_individu != 0)
    {
      _entity = _current_individu;  
      std::string sex = _entity->getSex();
      enumSex mmi_sex = e_Unknown;
      
      if (sex == GEDCOMParser::IndividualRecord::MALE)
	{
	  mmi_sex = e_Man;
	}
      if (sex == GEDCOMParser::IndividualRecord::FEMALE)
	{
	  mmi_sex = e_Woman;
	}
      _mmi_individual_record->setSex(mmi_sex);
    }
  return;
}


void BakeryGateway::ViewIndividualRecord::Goto(std::string const &key)
{
  if (get_individuals().size() != 0)
    {
      GEDCOMParser::IndividualRecords_t::const_iterator iter = get_individuals().find(key);
      if (iter != get_individuals().end())
	{
	  SetCurrentIndividu(iter->second.getPtr());
	  load_from_document();
	  _mmi_individual_record->show_all();
	}
    }
  return;
}

void BakeryGateway::ViewIndividualRecord::SetCurrentIndividu(GEDCOMParser::IndividualRecord * const individu)
{
  _current_individu = individu;
  return;
}

GEDCOMParser::IndividualRecords_t const &BakeryGateway::ViewIndividualRecord::get_individuals(void) const
{
  return get_document()->getIndividualRecords();
}
