/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/ViewIndividualEvents.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"
#include "BakeryGateway/ViewEvent.hh"

BakeryGateway::ViewIndividualEvents::ViewIndividualEvents(MMIIndividualEvents * mmi) : 
  _mmi_individual_events(mmi)
{
  return;
}

BakeryGateway::ViewIndividualEvents::~ViewIndividualEvents(void)
{
  return;
}

void BakeryGateway::ViewIndividualEvents::loadEventList(void)
{
  // handling of events list
  std::vector<std::string> * event_row = 0;
  std::string type;
  _mmi_individual_events->ClearList();
  GEDCOMParser::IndividualEvents_t const & events = _parent_entity->getIndividualEvents();
  for (GEDCOMParser::IndividualEvents_t::const_iterator iter = events.begin(); iter != events.end(); iter++)
    {
      event_row = new std::vector<std::string>;
      type = (*iter)->getType();
      event_row->push_back(type);
      if (!(*iter)->getEvent().Null())
	{
	  event_row->push_back((*iter)->getEvent()->getDate());
	  if (!(*iter)->getEvent()->getPlace().Null())
	    {
	      event_row->push_back((*iter)->getEvent()->getPlace().getPtr()->getPlaceValue());
	    }
	  else
	    {
	      event_row->push_back("");
	    }
	}
      else
	{
	  event_row->push_back("");
	  event_row->push_back("");
	}	   
      _mmi_individual_events->addEvent(*event_row);
      delete event_row; event_row = 0;
    }
  return;
}

void BakeryGateway::ViewIndividualEvents::load_from_document(void)
{
  if (_parent_entity != 0)
    {
      if (SubscribeesAreLoadable())
	{
	  delete_subscribed_views();
	  _mmi_individual_events->ClearWidgets();
	  MMIEvent * mmi_birth = _mmi_individual_events->addBirthWidget();
	  mmi_birth->setEventLabel(_("Birth"));
	  BakeryGateway::ViewBirthEvent * birth_view = new BakeryGateway::ViewBirthEvent(mmi_birth);
	  subscribe_view(birth_view);
	  birth_view->set_parent_entity(_parent_entity);
	  
	  MMIEvent * mmi_death = _mmi_individual_events->addDeathWidget();
	  mmi_death->setEventLabel(_("Death"));
	  BakeryGateway::ViewDeathEvent * death_view = new BakeryGateway::ViewDeathEvent(mmi_death);
	  subscribe_view(death_view);
	  death_view->set_parent_entity(_parent_entity);  
	}
      loadEventList();
    }
  return;
}

