/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/ViewIndividualAttributes.hh"
#include "GEDCOMParser/IndividualAttribute.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"
#include <functional>
#include <algorithm>


BakeryGateway::ViewIndividualAttributes::ViewIndividualAttributes(MMIIndividualAttributes * mmi) : 
  _mmi_individual_attributes(mmi),
  _during_load(false)
{
  _mmi_individual_attributes->getOccupationWidget()->changed.connect(SigC::slot(this, &ViewIndividualAttributes::on_Occupation_changed));  
  return;
}

void BakeryGateway::ViewIndividualAttributes::save_to_document(void)
{
  _is_loadable = false;
  if ((! _during_load) && (_parent_entity != 0))
    {
      GEDCOMHelper::IndividualRecordHelper helper(_parent_entity, get_document());
      std::string const new_occupation = _mmi_individual_attributes->getOccupation();
      if (helper.getOccupation() != new_occupation)
	{
	  helper.setOccupation(new_occupation);
	}
      get_document()->set_modified(true);
    }
  _is_loadable = true;
  return;
}

void BakeryGateway::ViewIndividualAttributes::on_Occupation_changed(void)
{
  save_to_document();
  return;
}

BakeryGateway::ViewIndividualAttributes::~ViewIndividualAttributes(void)
{
  return;
}

void BakeryGateway::ViewIndividualAttributes::load_from_document(void)
{
  _during_load = true;
  std::string occupation = "";
  if (_parent_entity != 0)
    {
      GEDCOMHelper::IndividualRecordHelper individual_record_helper(_parent_entity, get_document());
      occupation = individual_record_helper.getOccupation();
    }
  _mmi_individual_attributes->setOccupation(occupation);
  _during_load = false;
  return;
}
