/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERY_GATEWAY_VIEW_HH_
#define _BAKERY_GATEWAY_VIEW_HH_

#include "bakery/bakery.h"
#include "BakeryExtras/View_Composite.hh"
#include "config.h"
#include "BakeryGateway/Document.hh"
#include "MMIMain.hh"
#include "BakeryGateway/ViewIndividualRecord.hh"
#include "BakeryGateway/ViewPersonalName.hh"
#include "BakeryGateway/ViewIndividualAttributes.hh"
#include "BakeryGateway/ViewIndividualEvents.hh"
#include "BakeryGateway/ViewFamilyRecords.hh"
#include "BakeryGateway/ViewTreeBrowser.hh"
#include "BakeryGateway/ViewListBrowser.hh"
#include "BakeryGateway/ViewPersonalNameNote.hh"
#include "BakeryGateway/ViewIndividualRecordNote.hh"
#include "BakeryGateway/ViewHeader.hh"

namespace BakeryGateway {
   class View : public MMIMain,
		public BakeryExtras::View_Composite<Document>
   {
   public:
     View();
     virtual ~View();
     void on_menu_TreeBrowser(void);
     void on_menu_ListBrowser(void);
     void on_menu_DataHeader(void);
     ViewIndividualRecord * getViewIndividualRecord(void) { return _view_individualrecord; };
   protected:
   private:
     void DeleteViewTreeBrowser(void);
     int cb_DeleteViewTreeBrowser(GdkEventAny *);
     void DeleteViewListBrowser(void);
     int cb_DeleteViewListBrowser(GdkEventAny *);
     void DeleteViewDataHeader(void);
     int cb_DeleteViewDataHeader(GdkEventAny *);
     ViewIndividualRecord * _view_individualrecord;
     ViewPersonalName * _view_personalname;
     ViewIndividualAttributes * _view_individualattributes;
     ViewIndividualEvents * _view_individualevents;
     ViewParentFamilyRecords * _view_childtofamilylink;
     ViewUnionFamilyRecords * _view_spousetofamilylink;
     ViewTreeBrowser * _view_tree_browser;
     ViewListBrowser * _view_list_browser;
     ViewPersonalNameNote * _view_personalname_note;
     ViewIndividualRecordNote * _view_individualrecord_note;
     ViewHeader * _view_header;
   };
};

#endif
