/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/View.hh"
#include "BakeryGateway/ViewIndividualEventNoteFactory.hh"
#include "BakeryGateway/ViewIndividualRecordTargetFactory.hh"
#include "BakeryGateway/ViewFamilyRecordFactory.hh"

BakeryGateway::View::View() :
  _view_tree_browser(0),
  _view_list_browser(0),
  _view_header(0)
{
  _view_individualrecord = new BakeryGateway::ViewIndividualRecord(MMIIndividualRecord);
  _view_personalname = new BakeryGateway::ViewPersonalName(MMIIndividualRecord->MMIPersonalName);
  _view_individualattributes = new BakeryGateway::ViewIndividualAttributes(MMIIndividualRecord->MMIIndividualAttributes);
  _view_individualevents = new BakeryGateway::ViewIndividualEvents(MMIIndividualRecord->MMIIndividualEvents);
  _view_childtofamilylink = new BakeryGateway::ViewParentFamilyRecords (MMIIndividualRecord->MMIFamilyRecords);
  _view_childtofamilylink->setFactory(new BakeryGateway::ViewFamilyRecordFactory());
  _view_childtofamilylink->setParentViewIndividualRecord(_view_individualrecord);
  _view_spousetofamilylink = new BakeryGateway::ViewUnionFamilyRecords (MMIIndividualRecord->MMIFamilyRecords2);
  _view_spousetofamilylink->setFactory(new BakeryGateway::ViewFamilyRecordFactory());
  _view_spousetofamilylink->setParentViewIndividualRecord(_view_individualrecord);
  _view_personalname_note = new BakeryGateway::ViewPersonalNameNote(MMIIndividualRecord->MMIPersonalName->MMIPersonalNameNote);
  _view_individualrecord_note = new BakeryGateway::ViewIndividualRecordNote(MMIIndividualRecord->MMIIndividualRecordNote);
  add_view(_view_individualrecord);
  _view_individualrecord->subscribe_view(_view_personalname);
  _view_individualrecord->subscribe_view(_view_individualattributes);
  _view_individualrecord->subscribe_view(_view_individualevents);
  _view_individualrecord->subscribe_view(_view_childtofamilylink);
  _view_individualrecord->subscribe_view(_view_spousetofamilylink);
  _view_individualevents->setFactory(new BakeryGateway::ViewIndividualEventNoteFactory());
  _view_individualrecord->subscribe_view(_view_individualrecord_note);
  _view_personalname->subscribe_view(_view_personalname_note);
  show_all();
}

BakeryGateway::View::~View()
{
  DeleteViewTreeBrowser();
  DeleteViewListBrowser();
  DeleteViewDataHeader();
  return;
}

void BakeryGateway::View::on_menu_TreeBrowser(void)
{
  if (_view_tree_browser == 0)
    {
      _view_tree_browser = new BakeryGateway::ViewTreeBrowser();
      _view_individualrecord->subscribe_view(_view_tree_browser);
      BakeryGateway::ViewIndividualRecordTargetFactory * target_factory = new BakeryGateway::ViewIndividualRecordTargetFactory();
      target_factory->setDefaultTarget(_view_individualrecord);
      _view_tree_browser->setTargetFactory(target_factory);
      _view_tree_browser->getMMI().delete_event.connect(slot(this, &BakeryGateway::View::cb_DeleteViewTreeBrowser));
      _view_individualrecord->notify_subscribees();
//       if (!get_document()->get_is_new())
// 	{
// 	  _view_tree_browser->load_from_document();
// 	}
    }
  return;
}


void BakeryGateway::View::on_menu_ListBrowser(void)
{
  if (_view_list_browser == 0)
    {
      _view_list_browser = new BakeryGateway::ViewListBrowser();
      _view_individualrecord->subscribe_view(_view_list_browser);
      BakeryGateway::ViewIndividualRecordTargetFactory * target_factory = new BakeryGateway::ViewIndividualRecordTargetFactory();
      target_factory->setDefaultTarget(_view_individualrecord);
      _view_list_browser->setTargetFactory(target_factory);
      _view_list_browser->getMMI().delete_event.connect(slot(this, &BakeryGateway::View::cb_DeleteViewListBrowser));
      _view_individualrecord->notify_subscribees();
//        if (!get_document()->get_is_new())
//  	{
//  	  _view_list_browser->load_from_document();
//  	}
    }
  return;
}

void BakeryGateway::View::on_menu_DataHeader(void)
{
  if (_view_header == 0)
    {
      _view_header = new BakeryGateway::ViewHeader();
      add_view(_view_header);
      _view_header->getMMI()->delete_event.connect(slot(this, &BakeryGateway::View::cb_DeleteViewDataHeader));
      _view_header->load_from_document();
    }
  return;
}

void BakeryGateway::View::DeleteViewDataHeader(void)
{
  remove_view(_view_header);
  delete _view_header; _view_header = 0;
  return;
}

void BakeryGateway::View::DeleteViewTreeBrowser(void)
{
  _view_individualrecord->unsubscribe_view(_view_tree_browser);
  delete _view_tree_browser; _view_tree_browser = 0;
  return;
}

void BakeryGateway::View::DeleteViewListBrowser(void)
{
  _view_individualrecord->unsubscribe_view(_view_list_browser);
  delete _view_list_browser; _view_list_browser = 0;
  return;
}

int BakeryGateway::View::cb_DeleteViewTreeBrowser(GdkEventAny * event)
{
  DeleteViewTreeBrowser();
  return 0;
}

int BakeryGateway::View::cb_DeleteViewListBrowser(GdkEventAny * event)
{
  DeleteViewListBrowser();
  return 0;
}

int BakeryGateway::View::cb_DeleteViewDataHeader(GdkEventAny * event)
{
  DeleteViewDataHeader();
  return 0;
}



