/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


#ifndef _PREDICATE_MENU_ITEMS_FACTORY_HH_
#define _PREDICATE_MENU_ITEMS_FACTORY_HH_

#include "widgets/MenuItemsFactory.hh"

#include "GEDCOMParser/Predicates/PredicateIndividualRecords.hh"

#include <vector>

class PredicateMenuItemsFactory : public MenuItemsFactory
{
public:
  PredicateMenuItemsFactory(void);
  typedef SmartPtr < GEDCOMParser::Predicates::PredicateIndividualRecords > IndividualRecordPredicate;
  typedef std::vector < IndividualRecordPredicate > IndividualRecordPredicates_t;  
  void setPredicates(IndividualRecordPredicates_t * const);
  void setIndividualRecords(GEDCOMParser::IndividualRecords_t const &);
  virtual MenuItems_t * getMenuItems(void) const;
private:
  IndividualRecordPredicates_t * _predicates;
  GEDCOMParser::IndividualRecords_t const * _individual_records;
};

#endif
