/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYEXTRAS_VIEWNAVIGATOR_HH_
#define _BAKERYEXTRAS_VIEWNAVIGATOR_HH_

#include "bakery/bakery.h"
#include "BakeryExtras/View.hh"
#include "BakeryExtras/View_Composite.hh"
#include "BakeryExtras/View_Target.hh"
#include "BakeryExtras/View_TargetFactory.hh"
#include <sigc++/object.h>
#include <iostream>

namespace BakeryExtras {
  template< class T_Document, class T_KeyType >
  class View_Navigator : virtual public BakeryExtras::View<T_Document>,
			 public SigC::Object
  {
  public:
    View_Navigator() : 
      _target_factory(0)
    {
    }

    virtual ~View_Navigator()
    {
      delete _target_factory; _target_factory = 0;
    }
    View_TargetFactory < T_Document, T_KeyType > * getTargetFactory(void)
    {
      return _target_factory;
    }
    void setTargetFactory(View_TargetFactory < T_Document, T_KeyType > * target_factory)
    { 
      _target_factory = target_factory;
      return;
    }

    virtual void Navigate(T_KeyType const & key, bool create_window = false)
    {
      if (_target_factory != 0)
	{
	  BakeryExtras::View_Target < T_Document, T_KeyType > * target = 0;
	  if (create_window == true)
	    {
	      BakeryExtras::View < T_Document > * tmp_view = 0;
	      tmp_view = _target_factory->getNewView();
	      tmp_view->set_document(get_document());
	      BakeryExtras::View_Composite < T_Document > * main_view = 
	      dynamic_cast<BakeryExtras::View_Composite < T_Document > *>(get_document()->get_view());
	      if (main_view != 0)
		{
		  main_view->add_view(tmp_view);
		}
	      tmp_view->load_from_document();  
	      target = _target_factory->getTarget(tmp_view);
	    }
	  else
	    {
	      target = _target_factory->getDefaultTarget();
	    }
	  if (target != 0)
	    {
	      target->Goto(key);
	    }
	}
    }
  private:
    View_TargetFactory < T_Document, T_KeyType > * _target_factory;
    
  };
};

#endif
