/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYEXTRAS_VIEW_LINKED_HH_
#define _BAKERYEXTRAS_VIEW_LINKED_HH_

#include "bakery/bakery.h"
#include "BakeryExtras/View.hh"

namespace BakeryExtras {
  template< class T_Document , class T_ParentEntity >
  class View_Linked : virtual public BakeryExtras::View<T_Document>
  {
  public:
    View_Linked(T_ParentEntity * parent = 0) : _parent_entity(parent)
    {}
    virtual ~View_Linked() 
    {
    }
    virtual void set_parent_entity(T_ParentEntity * parent) { 
      parent_change_before_callback();
      _parent_entity = parent; 
      load_from_document();
      parent_change_after_callback();
    }
    virtual void parent_change_before_callback() {}
    virtual void parent_change_after_callback() {}
  protected:
    T_ParentEntity * _parent_entity;
  };
};

#endif

