<?
/**
* This API can be used to connect to a DIG Server. Also you can use it to build 
* a request and send it to the server.
*
* If you find this software useful or if you found some bugs write a mail
* to "bacher (at) bash (minus) it (dot) de"
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Header: /sources/gfo/BODIGger/lib/Expression.php,v 1.1 2006/12/12 15:59:48 punkrock Exp $
*
* @copyright 2006 joshua bacher
* @author joshua bacher
* @package DIGExpression
*/


function tabdepth($a){
$tab='';
for ($i=0 ; $i<$a; $i++)	
	$tab.="\t";
return $tab;
}
/**
* expressions are build via this Class
* @package DIGExpression
*/
abstract class Expression
{
	public abstract function toDIG($depth=0);
}

class Atom extends Expression 
{
	public $name;
	public function Atom ($name){
		$this->name=$name;
	}
	public function toDIG($depth=0){
		return $this->name;
	}
	public function definition(){
	}
}

class Ratom extends Atom 
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<ratom name=\"{$this->name}\"/>\n";
	}
	public function definition(){
		return "<defrole name=\"{$this->name}\">";
	}

}

class Catom extends Atom 
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<catom name=\"{$this->name}\"/>\n";
	}
	public function definition(){
		return "<defconcept name=\"{$this->name}\">";
	}
}

abstract class Quantify extends Expression
{
	public $atom;
	public $expression;
	public function Quantify(Ratom $atom, Expression $expression){
		$this->atom=$atom;
		$this->expression=$expression;
	}
	public function toDIG($depth=0){}
	public function definition(){}
}

class All extends Quantify
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<all>\n"
		.$this->atom->toDIG($depth+1)
		.$this->expression->toDIG($depth+1)
		.tabdepth($depth)."</all>\n";
	}
}

class Some extends Quantify
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<some>\n"
			.$this->atom->toDIG($depth+1)
			.$this->expression->toDIG($depth+1)
			.tabdepth($depth)."</some>\n";
	}
}

class PropertyRestriction extends Quantify 
{
	public $num;
	public function PropertyRestriction(Ratom $atom, Expression $expression, $num){
		$this->num=$num;
		$this->atom=$atom;
		$this->expression=$expression;
	}
}

class AtMost extends PropertyRestriction 
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<atmost num=\"{$this->num}\">\n"
		.$this->atom->toDIG($depth+1)
		.$this->expression->toDIG($depth+1)
		.tabdepth($depth)."</atmost>";
	}
}

class AtLeast extends PropertyRestriction 
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<atleast num=\"{$this->num}\">\n"
		.$this->atom->toDIG($depth+1)
		.$this->expression->toDIG($depth+1)
		.tabdepth($depth)."</atleast>";
	}
}

class UNION extends Expression 
{
	public $args;
	public function __construct(){
		$args = func_get_args();
		foreach ($args as $key => $val)	{
			if (! $val instanceof Expression )
				throw new Exception ("Only Instances of Expression allowed\n".print_r($key));
			else $this->args[]=$val;
		}
	}
	public function UNIONtoDIG( $depth=0){
		$ret;
		foreach ($this->args as $key=>$val){
			$ret.=$val->toDIG($depth);
		}
		return $ret;
	}
	public function toDIG($depth=0){}
}

class ImpliesC extends UNION
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<impliesc >\n"
		.$this->UNIONtoDIG($depth+1)
		.tabdepth($depth)."</impliesc>\n";
	}
}

class OrE extends UNION
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<or >\n"
		.$this->UNIONtoDIG($depth+1)
		.tabdepth($depth)."</or>\n";
	}
}
class AndE extends UNION
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<and >\n"
		.$this->UNIONtoDIG($depth+1)
		.tabdepth($depth)."</and>\n";
	}
}
class EqualsC extends UNION
{
	public function toDIG($depth=0){
		return tabdepth($depth)."<equalc >\n"
		.$this->UNIONtoDIG($depth+1)
		.tabdepth($depth)."</equalc>\n";
	}
}


