#!/usr/bin/php5
<?
/**
* This is a command line Interface for communicating with the DIG Server.
* Perform ask and tell querys over it, check the connection, or just make a 
* identifu Request.
* example usage: ./digger.php   -c digger.ini -r DIGImports/gfo.dig
*
* If you find this software useful or if you found some bugs write a mail
* to "bacher (at) bash (minus) it (dot) de"
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Header: /sources/gfo/BODIGger/digger.php,v 1.18 2007/01/12 15:04:05 punkrock Exp $
*
* @copyright 2006 joshua bacher
* @author joshua bacher
* @package DIGger
* @subpackage CLI
*/

if (empty($_ENV["DIGLIB"])){
	echo "################################################\n";
	echo "You need to set the environment variable DIGLIB.\n";
	echo "###################################3############\n";
	exit;
}
require_once($_ENV["DIGLIB"]."/DIGger.php");
require_once($_ENV["DIGLIB"]."/Getargs.php");

$config=array(
	"newkb"  =>	array(
				"short"=>"n", 
				"min"=>0, 
				"max"=>0, 
				"desc"=>"Create a new Knowledgebase and save the uri in config.ini"
			), 
	"version"  =>	array(
				"short"=>"v", 
				"min"=>0, 
				"max"=>0, 
				"desc"=>"print the version of the program and exit"
			), 
	"help"  =>	array(
				"short"=>"h", 
				"min"=>0, 
				"max"=>0, 
				"desc"=>"prints this help."
			), 
	"quiet"  =>	array(
				"short"=>"q", 
				"min"=>0, 
				"max"=>0, 
				"desc"=>"Don't print any message. if debug is set program will still output debugmessages."
			),
	"debug"  =>	array(
				"short"=>"d", 
				"min"=>0, 
				"max"=>0, 
				"desc"=>"Prints a lot of stuff that was returned from the digserver."
			),
	"file"  =>	array(
				"short"=>"f", 
				"max"=>-1, 
				"desc"=>"Send a request read from FILE to the Server"
			),
	"type"  =>	array(
				"short"=>"t", 
				"max"=>1, 
				"desc"=>"Specify type of query to send. values are tell identify and ask, defaults to tell",
				"value"=>"tell"
			),
	"config"  =>	array(
				"short"=>"c", 
				"max"=>1, 
				"desc"=>"specify a config file that should be used for the communication with the server."
			)
	);

$type_opts=array(0=>"tell", 1=>"ask", 2=>"identify");
asort($config);
$args=Console_Getargs::factory($config);

if (PEAR::isError($args) || $args->isDefined('help')) {
	$header = 'Usage: '.basename($_SERVER['SCRIPT_NAME'])." [options]\n\n";
	if ($args->getCode() === CONSOLE_GETARGS_ERROR_USER) {
        	echo Console_Getargs::getHelp($config, $header, $args->getMessage())."\n";
    	} else if ($args->getCode() === CONSOLE_GETARGS_HELP) {
        echo Console_Getargs::getHelp($config)."\n";
    }
    exit;
}

if ($args->isDefined("version")){
	echo "$Header: /sources/gfo/BODIGger/digger.php,v 1.18 2007/01/12 15:04:05 punkrock Exp $ request\n";
	exit;
}
$quiet=$args->isDefined("quiet");
$DIGconnection=new DIGger($args->isDefined("debug"));
if ($args->isDefined("debug") && ! $quiet){
	print Console_Color::convert("%yStarted in verbose mode.%n\n");
	sleep(1);
	//exit;
}
$tmp=$args->getValue("config");
if (empty($tmp)) {
        echo Console_Getargs::getHelp($config)."\n";
	exit;
}
$DIGconnection->readConfigFile($args->getValue("config"));
if($args->isDefined("newkb")){
	if ($DIGconnection->identify()!=true){
		if (!$quiet){
			print Console_Color::convert("Connection to host {$DIGconnection->_HOST}%n ");
			print console_color::convert("%_%rfailed.%n\n");
		}
		exit;
	}
	else	$DIGconnection->newKB();
}
if($args->isDefined("type") ){
	if (!in_array($args->getValue("type"), $type_opts)){
		print Console_Color::convert("%rUnsupported type: %n%_{$args->getValue('type')}%n\nAllowed types are: ". implode(", ", $type_opts)."\n");
		exit;
	}
	if (!$quiet)print Console_Color::convert("Connection to host {$DIGconnection->_HOST}%n ");
	if ($DIGconnection->identify()==true){
		if (!$quiet)print Console_Color::convert("%_established.%n\n");
		if ($DIGconnection->isError()){
			print Console_Color::convert(genErrorMSG($DIGconnection));
			exit;
		}
	}else{ 
		if (!$quiet){
			print console_color::convert("%_%rfailed.%n\n");
		}else {
			print Console_Color::convert("%_Connection %rfailed.%n %_Please check the output of your Response. Use the -d switch for that.%n\n ");
		}
		exit;
	}

	if ($args->getValue("type")=="tell"){
		if (!$args->isDefined("file")){
			print Console_Color::convert("\n%rYou need to specify a input File if you use the tell mode%n\n");
			exit;
		}
		if (!$quiet)print Console_Color::convert("\t%p%_Performing request%n\t");
		$req=($DIGconnection->tell($args->getValue("file"), true))? "%g%_Ok.%n" : "%r%_failed.%n";
		if(!$quiet)print Console_Color::convert($req."\n");
		
	}elseif ($args->getValue("type")=="ask"){
		if (!$quiet)print Console_Color::convert("\t%p%_Performing request%n\t");
		$DIGAsk=new DIGAsk();
		$DIGAsk->readConfigFile($args->getValue("config"));
		$DIGAsk->allConcepts();
		$req=$DIGAsk->submit();
		if ($DIGAsk->isError())Console_Color::convert(genErrorMSG($DIGAsk));
		if(!$quiet)print Console_Color::convert($req."\n");

	}elseif ($args->getValue("type")=="identify"){
		//exit;
	}

	if ($DIGconnection->isError())print Console_Color::convert(genErrorMSG($DIGconnection));
	elseif(!$quiet) print Console_Color::convert("%_New URI: %n".$DIGconnection->_URI."%n\n");

//	print_r($DIGconnection->_XMLResponse);
}

function genErrorMSG($DIG){
	return "%r%_DIG Server returned error: %n%_".$DIG->response_val."\n%n";
}
?>
